/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids;

import java.util.ArrayList;

public class Solution<T> {
    private ArrayList<T> medoids = new ArrayList();
    private double total_similarity;
    private long computed_similarities;
    private final long start_time;
    private long end_time;
    private final long dataset_size;
    private int trials;
    private int iterations;

    public Solution(long dataset_size) {
        this.dataset_size = dataset_size;
        this.start_time = System.currentTimeMillis();
    }

    public final ArrayList<T> getMedoids() {
        return this.medoids;
    }

    public final double getTotalSimilarity() {
        return this.total_similarity;
    }

    public final long getComputedSimilarities() {
        return this.computed_similarities;
    }

    public final long getStartTime() {
        return this.start_time;
    }

    public final long getEndTime() {
        return this.end_time;
    }

    public final long getDatasetSize() {
        return this.dataset_size;
    }

    public final int getTrials() {
        return this.trials;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final void setNewMedoids(ArrayList<T> medoids, double total_similarity) {
        this.medoids = medoids;
        this.total_similarity = total_similarity;
    }

    public final String toString() {
        return "Total similarity: " + this.total_similarity + "\nTrials: " + this.trials + "\nIterations: " + this.iterations + "\nComputed similarities: " + this.computed_similarities + "\nRun time: " + (this.end_time - this.start_time) / 1000L;
    }

    public final String toCSV() {
        return this.total_similarity + ";\t" + this.trials + ";\t" + this.iterations + ";\t" + this.computed_similarities + ";\t" + (this.end_time - this.start_time) / 1000L;
    }

    public final void incComputedSimilarities(long similarities) {
        this.computed_similarities += similarities;
    }

    public final void incIterations() {
        ++this.iterations;
    }

    public final void incTrials() {
        ++this.trials;
    }

    public final void end() {
        this.end_time = System.currentTimeMillis();
    }
}

