/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids;

import info.debatty.spark.kmedoids.Similarity;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.spark.api.java.function.FlatMapFunction;

class AssignToMedoid<T>
implements FlatMapFunction<Iterator<T>, Double> {
    private final List<T> medoids;
    private final Similarity<T> similarity;
    private final double imbalance;

    AssignToMedoid(List<T> medoids, Similarity<T> similarity, double imbalance) {
        this.medoids = medoids;
        this.similarity = similarity;
        this.imbalance = imbalance;
    }

    public Iterator<Double> call(Iterator<T> iterator) {
        int k = this.medoids.size();
        LinkedList<T> points = new LinkedList<T>();
        while (iterator.hasNext()) {
            points.add(iterator.next());
        }
        int n_local = points.size();
        double capacity = this.imbalance * (double)n_local / (double)k;
        int[] cluster_sizes = new int[k];
        double total_similarity = 0.0;
        for (Object point : points) {
            int cluster_index;
            double[] sims = new double[k];
            double[] values = new double[k];
            for (int i = 0; i < k; ++i) {
                sims[i] = this.similarity.similarity(point, this.medoids.get(i));
                values[i] = sims[i] * (1.0 - (double)cluster_sizes[i] / capacity);
            }
            int n = cluster_index = AssignToMedoid.argmax(values);
            cluster_sizes[n] = cluster_sizes[n] + 1;
            total_similarity += sims[cluster_index];
        }
        LinkedList<Double> result = new LinkedList<Double>();
        result.add(total_similarity);
        return result.iterator();
    }

    private static int argmax(double[] values) {
        double max = -1.7976931348623157E308;
        int max_index = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!(values[i] > max)) continue;
            max = values[i];
            max_index = i;
        }
        return max_index;
    }
}

