/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids.neighborgenerator;

import info.debatty.spark.kmedoids.NeighborGeneratorHelper;
import info.debatty.spark.kmedoids.NoNeighborFoundException;
import info.debatty.spark.kmedoids.Similarity;
import info.debatty.spark.kmedoids.Solution;
import info.debatty.spark.kmedoids.neighborgenerator.AbstractNeighborGenerator;
import java.util.ArrayList;
import java.util.Random;

public class SANeighborGenerator<T>
extends AbstractNeighborGenerator<T> {
    private final Random rand = new Random();
    private static final int MAX_TRIALS = 10000;
    private final double initial_temp;
    private final double gamma;

    public SANeighborGenerator(double initial_temp, double gamma) {
        this.initial_temp = initial_temp;
        this.gamma = gamma;
    }

    @Override
    public final ArrayList<T> getNeighbor(NeighborGeneratorHelper<T> helper, Solution<T> current_solution, Similarity<T> similarity) throws NoNeighborFoundException {
        ArrayList<T> new_solution = new ArrayList<T>(current_solution.getMedoids());
        int k = current_solution.getMedoids().size();
        for (int i = 0; i < 10000; ++i) {
            int failed_trials;
            int medoid_position = this.rand.nextInt(k);
            T new_medoid = helper.getRandomPoint();
            double sim = similarity.similarity(new_medoid, current_solution.getMedoids().get(medoid_position));
            if (!this.accept(sim, failed_trials = current_solution.getTrials() - current_solution.getIterations())) continue;
            new_solution.set(medoid_position, new_medoid);
            return new_solution;
        }
        throw new NoNeighborFoundException();
    }

    private boolean accept(double similarity, int failed_trials) {
        double temperature = this.initial_temp * Math.pow(this.gamma, failed_trials);
        double distance = 1.0 / similarity - 1.0;
        double value = -distance / temperature;
        double probability = Math.exp(value);
        return this.rand.nextDouble() <= probability;
    }
}

