/*
 * Decompiled with CFR 0.152.
 */
package info.debatty.spark.kmedoids.neighborgenerator;

import info.debatty.spark.kmedoids.NeighborGeneratorHelper;
import info.debatty.spark.kmedoids.NeighborGenerotor;
import info.debatty.spark.kmedoids.Similarity;
import info.debatty.spark.kmedoids.Solution;
import info.debatty.spark.kmedoids.neighborgenerator.Bin;
import info.debatty.spark.kmedoids.neighborgenerator.XY;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WindowNeighborGenerator<T>
implements NeighborGenerotor<T> {
    private static final double EXPANSION_COEFFICIENT = 1.001;
    private final Random rand = new Random();
    private int medoid_position;
    private double last_distance;
    private double current_solution_cost;
    private Bin[] bins;

    @Override
    public final ArrayList<T> getNeighbor(NeighborGeneratorHelper<T> helper, Solution<T> current_solution, Similarity<T> similarity) {
        double distance;
        T new_medoid;
        ArrayList<T> new_solution = new ArrayList<T>(current_solution.getMedoids());
        this.medoid_position = this.rand.nextInt(current_solution.getMedoids().size());
        T old_medoid = current_solution.getMedoids().get(this.medoid_position);
        double threshold = this.bins[this.medoid_position].threshold();
        while (true) {
            if (old_medoid.equals(new_medoid = helper.getRandomPoint())) {
                continue;
            }
            double sim = similarity.similarity(new_medoid, old_medoid);
            distance = 1.0 / sim - 1.0;
            if (!(distance > threshold)) break;
            threshold *= 1.001;
        }
        this.last_distance = distance;
        new_solution.set(this.medoid_position, new_medoid);
        return new_solution;
    }

    @Override
    public final void notifyNewSolution(List<T> solution, double cost) {
        this.current_solution_cost = cost;
        this.bins[this.medoid_position] = new Bin();
    }

    @Override
    public final void notifyCandidateSolutionCost(List<T> solution, double cost) {
        if (this.current_solution_cost == 0.0) {
            return;
        }
        double delta_cost = cost - this.current_solution_cost;
        XY point = new XY(this.last_distance, delta_cost);
        this.bins[this.medoid_position].add(point);
    }

    @Override
    public final void init(int k) {
        this.bins = new Bin[k];
        for (int i = 0; i < k; ++i) {
            this.bins[i] = new Bin();
        }
    }
}

