/*
 * Decompiled with CFR 0.152.
 */
package info.developia.hodor.processor;

import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import info.developia.hodor.Hodor;
import info.developia.hodor.HodorException;
import info.developia.hodor.annotation.HoldTheDoor;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class HodorProcessor
extends AbstractProcessor {
    private Filer filer;
    private Messager messager;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        roundEnvironment.getElementsAnnotatedWith(info.developia.hodor.annotation.Hodor.class).stream().findFirst().ifPresent(element -> {
            Element method = (Element)roundEnvironment.getElementsAnnotatedWith(HoldTheDoor.class).stream().findFirst().orElseThrow(() -> new HodorException("Hodor does not know what door to hold"));
            MethodSpec main = MethodSpec.methodBuilder((String)"main").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Void.TYPE).addParameter(String[].class, "args", new Modifier[0]).addStatement("$T.holdTheDoor((a) -> $L.$L(args),(t) -> $L.$L(t))", new Object[]{Hodor.class, element.getEnclosingElement().getSimpleName(), element.getSimpleName(), method.getEnclosingElement().getSimpleName(), method.getSimpleName()}).build();
            TypeSpec hodorWrapper = TypeSpec.classBuilder((String)(element.getEnclosingElement().getSimpleName() + "Hodor")).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(main).build();
            try {
                String packageName = this.processingEnv.getElementUtils().getPackageOf((Element)element).getQualifiedName().toString();
                JavaFile.builder((String)packageName, (TypeSpec)hodorWrapper).build().writeTo(this.filer);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new HodorException("Hodor doesn't know how to hold the door", e);
            }
            this.messager.printMessage(Diagnostic.Kind.NOTE, "Hodor knows what to do!");
        });
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of(info.developia.hodor.annotation.Hodor.class.getCanonicalName(), HoldTheDoor.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_16;
    }
}

