/*
 * Decompiled with CFR 0.152.
 */
package info.faljse.SDNotify;

import info.faljse.SDNotify.io.NativeDomainSocket;
import info.faljse.SDNotify.jna.CLibrary;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDNotify {
    private static final Logger log = LoggerFactory.getLogger(SDNotify.class);
    private static final String NOTIFY_SOCKET = "NOTIFY_SOCKET";
    private static final String WATCHDOG_USEC = "WATCHDOG_USEC";
    private static final String WATCHDOG_PID = "WATCHDOG_PID";
    private NativeDomainSocket sd;
    private static volatile SDNotify instance;
    private volatile boolean available = false;

    private SDNotify() {
        String socketName = System.getenv().get(NOTIFY_SOCKET);
        if (socketName == null || socketName.length() == 0) {
            log.warn("Environment variable \"{}\" not set. Ignoring calls to SDNotify.", (Object)NOTIFY_SOCKET);
            return;
        }
        try {
            if (socketName.charAt(0) == '@') {
                socketName = '\u0000' + socketName.substring(1);
            }
            CLibrary.SockAddr sockAddr = new CLibrary.SockAddr(socketName);
            this.sd = new NativeDomainSocket();
            this.sd.connect(sockAddr);
        }
        catch (Exception e) {
            log.warn("Notify init failed", (Throwable)e);
        }
        this.available = true;
    }

    public static boolean isAvailable() {
        return SDNotify.getInstance().available;
    }

    public static void sendNotify() {
        SDNotify.getInstance().sendString("READY=1");
    }

    public static void sendReloading() {
        SDNotify.getInstance().sendString("RELOADING=1");
    }

    public static void sendStopping() {
        SDNotify.getInstance().sendString("STOPPING=1");
    }

    public static void sendStatus(String status) {
        SDNotify.getInstance().sendString(String.format("STATUS=%s", status));
    }

    public static void sendErrno(int errno) {
        SDNotify.getInstance().sendString(String.format("ERRNO=%d", errno));
    }

    public static void sendBusError(String error) {
        SDNotify.getInstance().sendString(String.format("BUSERROR=%s", error));
    }

    public static void sendMainPID(int pid) {
        SDNotify.getInstance().sendString(String.format("MAINPID=%d", pid));
    }

    public static void sendWatchdog() {
        SDNotify.getInstance().sendString("WATCHDOG=1");
    }

    public static void sendRaw(String message) {
        SDNotify.getInstance().sendString(message);
    }

    public static boolean isWatchdogEnabled() {
        String watchdog_pid = System.getenv(WATCHDOG_PID);
        return SDNotify.isAvailable() && SDNotify.getWatchdogFrequency() > 0L && (SDNotify.isEmpty(watchdog_pid) || String.valueOf(SDNotify.getPid()).equals(watchdog_pid));
    }

    public static long getWatchdogFrequency() {
        String watchdog_usec = System.getenv(WATCHDOG_USEC);
        return SDNotify.isAvailable() && !SDNotify.isEmpty(watchdog_usec) ? Long.parseLong(watchdog_usec) : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SDNotify getInstance() {
        if (instance != null) return instance;
        Class<SDNotify> clazz = SDNotify.class;
        synchronized (SDNotify.class) {
            if (instance != null) return instance;
            instance = new SDNotify();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void sendString(String s) {
        if (this.sd == null || !this.available || s == null) {
            return;
        }
        this.sd.send(s.getBytes(StandardCharsets.UTF_8), s.length());
    }

    public static int getPid() {
        return CLibrary.clib.getpid();
    }

    private static boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }
}

