/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.spata;

import cats.effect.kernel.Sync;
import cats.effect.package$;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable$;
import fs2.Stream;
import fs2.Stream$;
import info.fingo.spata.CSVConfig;
import info.fingo.spata.CSVParser$;
import info.fingo.spata.Content;
import info.fingo.spata.Content$;
import info.fingo.spata.Position$;
import info.fingo.spata.Record;
import info.fingo.spata.error.CSVException;
import info.fingo.spata.error.ParsingErrorCode$MissingHeader$;
import info.fingo.spata.error.StructureException;
import info.fingo.spata.error.StructureException$;
import info.fingo.spata.parser.CharParser;
import info.fingo.spata.parser.FieldParser;
import info.fingo.spata.parser.RecordParser;
import info.fingo.spata.util.Logger;
import info.fingo.spata.util.Logger$;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.NotGiven$;
import scala.util.Try$;

public final class CSVParser<F> {
    private final CSVConfig config;
    private final Sync<F> evidence$1;
    private final Logger<F> evidence$2;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CSVParser$.class.getDeclaredField("config$lzy1"));

    public static <F> CSVParser<F> apply(Sync<F> sync, Logger<F> logger) {
        return CSVParser$.MODULE$.apply(sync, logger);
    }

    public CSVParser(CSVConfig config, Sync<F> evidence$1, Logger<F> evidence$2) {
        this.config = config;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }

    public Function1<Stream<F, Object>, Stream<F, Record>> parse() {
        return (Function1 & Serializable)in -> {
            CharParser cp = new CharParser(this.config.fieldDelimiter(), this.config.recordDelimiter(), this.config.quoteMark(), this.config.trimSpaces());
            FieldParser fp = new FieldParser(this.config.fieldSizeLimit());
            RecordParser rp = new RecordParser();
            Stream stream = Logger$.MODULE$.apply(this.evidence$2).infoS((Function0<String>)((Function0 & Serializable)this::$anonfun$1)).$greater$greater(() -> CSVParser.$anonfun$2(in, cp, fp, rp), NotGiven$.MODULE$.value());
            Pull<?, Either<StructureException, Content<F>>, BoxedUnit> pull = this.config.hasHeader() ? this.contentWithHeader(stream) : this.contentWithoutHeader(stream);
            Pull pull2 = Pull$.MODULE$.StreamPullOps(pull);
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull2).rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$1)).flatMap((Function1 & Serializable)_$2 -> _$2.toRecords(), NotGiven$.MODULE$.value()).through(this.debugCount()).handleErrorWith((Function1 & Serializable)ex -> Logger$.MODULE$.apply(this.evidence$2).errorS((Function0<String>)((Function0 & Serializable)() -> CSVParser.parse$$anonfun$1$$anonfun$2$$anonfun$1(ex))).$greater$greater(() -> this.parse$$anonfun$1$$anonfun$2$$anonfun$2(ex), NotGiven$.MODULE$.value())).onFinalize(Logger$.MODULE$.apply(this.evidence$2).debug((Function0<String>)((Function0 & Serializable)CSVParser::parse$$anonfun$1$$anonfun$3)), this.evidence$1);
        };
    }

    private Pull<?, Either<StructureException, Content<F>>, BoxedUnit> contentWithHeader(Stream<F, RecordParser.RecordResult> stream) {
        Stream stream2 = Stream$.MODULE$.InvariantOps(stream);
        Stream stream3 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream2)).fs2$Stream$ToPull$$self();
        return Stream.ToPull$.MODULE$.uncons1$extension(stream3).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                RecordParser.RecordResult h = (RecordParser.RecordResult)tuple2._1();
                Stream t = (Stream)tuple2._2();
                return Pull$.MODULE$.output1(Content$.MODULE$.apply(h, t, this.config.headerMap(), this.evidence$1, this.evidence$2));
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.raiseError((Throwable)new StructureException(ParsingErrorCode$MissingHeader$.MODULE$, Position$.MODULE$.some(0, 1), StructureException$.MODULE$.$lessinit$greater$default$3(), StructureException$.MODULE$.$lessinit$greater$default$4()), RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$1));
            }
            throw new MatchError((Object)option);
        });
    }

    private Pull<?, Either<StructureException, Content<F>>, BoxedUnit> contentWithoutHeader(Stream<F, RecordParser.RecordResult> stream) {
        Stream stream2 = Stream$.MODULE$.InvariantOps(stream);
        Stream stream3 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream2)).fs2$Stream$ToPull$$self();
        return Stream.ToPull$.MODULE$.peek1$extension(stream3).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                RecordParser.RecordResult h = (RecordParser.RecordResult)tuple2._1();
                Stream s = (Stream)tuple2._2();
                return Pull$.MODULE$.output1(Content$.MODULE$.apply(h.fieldNum(), s, this.config.headerMap(), this.evidence$1, this.evidence$2));
            }
            if (None$.MODULE$.equals(option)) {
                Stream stream = Stream$.MODULE$.PureOps(Stream$.MODULE$.empty());
                return Pull$.MODULE$.output1(Content$.MODULE$.apply(0, Stream.PureOps$.MODULE$.apply$extension(stream), this.config.headerMap(), this.evidence$1, this.evidence$2));
            }
            throw new MatchError((Object)option);
        });
    }

    private Function1<Stream<F, Record>, Stream<F, Record>> debugCount() {
        return (Function1 & Serializable)in -> {
            if (Logger$.MODULE$.apply(this.evidence$2).isDebug()) {
                return in.noneTerminate().mapAccumulate((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable)(s, o) -> CSVParser.debugCount$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToInt((Object)s), (Option)o)).flatMap((Function1 & Serializable)x$1 -> {
                    int n = BoxesRunTime.unboxToInt((Object)x$1._1());
                    Option option = (Option)x$1._2();
                    Option option2 = option;
                    if (option2 instanceof Some) {
                        Record r = (Record)((Some)option2).value();
                        return Stream$.MODULE$.emit((Object)r);
                    }
                    if (None$.MODULE$.equals(option2)) {
                        return Logger$.MODULE$.apply(this.evidence$2).debugS((Function0<String>)((Function0 & Serializable)() -> CSVParser.debugCount$$anonfun$1$$anonfun$2$$anonfun$1(n))).$greater$greater(CSVParser::debugCount$$anonfun$1$$anonfun$2$$anonfun$2, NotGiven$.MODULE$.value());
                    }
                    throw new MatchError((Object)option2);
                }, NotGiven$.MODULE$.value());
            }
            return in;
        };
    }

    public F get(Stream<F, Object> stream) throws StructureException {
        return this.get(stream, (Option<Object>)None$.MODULE$);
    }

    public F get(Stream<F, Object> stream, long limit) throws StructureException {
        return this.get(stream, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)limit)));
    }

    private F get(Stream<F, Object> stream, Option<Object> limit) {
        Stream stream2;
        Stream s = stream.through(this.parse());
        Option<Object> option = limit;
        if (option instanceof Some) {
            long l = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            stream2 = s.take(l);
        } else {
            stream2 = s;
        }
        Stream limited = stream2;
        return (F)limited.compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.evidence$1))).toList();
    }

    public F process(Stream<F, Object> stream, Function1<Record, Object> cb) throws CSVException {
        Function1<Stream<F, Record>, Stream<F, Object>> effect = this.evalCallback(cb);
        return (F)stream.through(this.parse()).through(effect).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forSync(this.evidence$1))).drain();
    }

    private Function1<Stream<F, Record>, Stream<F, Object>> evalCallback(Function1<Record, Object> cb) {
        return (Function1 & Serializable)_$3 -> {
            Stream stream = _$3.evalMap((Function1 & Serializable)pr -> package$.MODULE$.Sync().apply(this.evidence$1).delay(() -> CSVParser.$anonfun$3$$anonfun$1(cb, pr)));
            return stream.takeWhile((Function1 & Serializable)_$4 -> CSVParser.evalCallback$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$4)), stream.takeWhile$default$2());
        };
    }

    public Async<F> async(cats.effect.kernel.Async<F> F) {
        return new Async<F>(this, F, this.evidence$2);
    }

    private final String $anonfun$1() {
        return "Parsing CSV with " + this.config;
    }

    private static final Stream $anonfun$2(Stream in$1, CharParser cp$1, FieldParser fp$1, RecordParser rp$1) {
        return in$1.through(cp$1.toCharResults()).through(fp$1.toFields()).through(rp$1.toRecords());
    }

    private static final String parse$$anonfun$1$$anonfun$2$$anonfun$1(Throwable ex$1) {
        return ex$1.getMessage();
    }

    private final Stream parse$$anonfun$1$$anonfun$2$$anonfun$2(Throwable ex$2) {
        return Stream$.MODULE$.raiseError(ex$2, RaiseThrowable$.MODULE$.fromApplicativeError(this.evidence$1));
    }

    private static final String parse$$anonfun$1$$anonfun$3() {
        return "CSV parsing finished";
    }

    private static final /* synthetic */ Tuple2 debugCount$$anonfun$1$$anonfun$1(int s, Option o) {
        Option option = o;
        if (option instanceof Some) {
            Record r = (Record)((Some)option).value();
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)r.rowNum()), (Object)o);
        }
        if (None$.MODULE$.equals(option)) {
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)s), (Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private static final String debugCount$$anonfun$1$$anonfun$2$$anonfun$1(int s$1) {
        return "CSV fully parsed, " + s$1 + " rows processed";
    }

    private static final Stream debugCount$$anonfun$1$$anonfun$2$$anonfun$2() {
        return Stream$.MODULE$.empty();
    }

    private static final boolean $anonfun$3$$anonfun$1(Function1 cb$3, Record pr$1) {
        return BoxesRunTime.unboxToBoolean((Object)cb$3.apply((Object)pr$1));
    }

    private static final /* synthetic */ boolean evalCallback$$anonfun$1$$anonfun$1(boolean _$4) {
        return _$4;
    }

    public static final class Async<F> {
        private final CSVParser<F> parser;
        private final cats.effect.kernel.Async<F> evidence$5;

        public Async(CSVParser<F> parser, cats.effect.kernel.Async<F> evidence$5, Logger<F> evidence$6) {
            this.parser = parser;
            this.evidence$5 = evidence$5;
        }

        public F process(Stream<F, Object> stream, int maxConcurrent, Function1<Record, Object> cb) {
            Function1<Stream<F, Record>, Stream<F, Object>> effect = this.evalCallback(maxConcurrent, cb);
            return (F)stream.through(this.parser.parse()).through(effect).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent(this.evidence$5))).drain();
        }

        public int process$default$2() {
            return 1;
        }

        private Function1<Stream<F, Record>, Stream<F, Object>> evalCallback(int maxConcurrent, Function1<Record, Object> cb) {
            return (Function1 & Serializable)_$7 -> {
                Stream stream = _$7.mapAsync(maxConcurrent, (Function1 & Serializable)pr -> package$.MODULE$.Async().apply(this.evidence$5).async_((Function1)(JProcedure1 & Serializable)call -> {
                    Either result = Try$.MODULE$.apply(() -> this.$anonfun$5(cb, pr)).toEither();
                    call.apply((Object)result);
                }), this.evidence$5);
                return stream.takeWhile((Function1 & Serializable)_$8 -> this.evalCallback$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$8)), stream.takeWhile$default$2());
            };
        }

        private final boolean $anonfun$5(Function1 cb$7, Record pr$3) {
            return BoxesRunTime.unboxToBoolean((Object)cb$7.apply((Object)pr$3));
        }

        private final /* synthetic */ boolean evalCallback$$anonfun$2$$anonfun$1(boolean _$8) {
            return _$8;
        }
    }
}

