/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.spata;

import fs2.Chunk;
import fs2.Chunk$;
import fs2.Pull;
import fs2.Pull$;
import fs2.RaiseThrowable;
import fs2.Stream;
import fs2.Stream$;
import info.fingo.spata.CSVConfig;
import info.fingo.spata.CSVConfig$EscapeAll$;
import info.fingo.spata.CSVConfig$EscapeRequired$;
import info.fingo.spata.CSVConfig$EscapeSpaces$;
import info.fingo.spata.CSVRenderer$;
import info.fingo.spata.Header;
import info.fingo.spata.Position$;
import info.fingo.spata.Record;
import info.fingo.spata.error.FieldInfo$;
import info.fingo.spata.error.HeaderError;
import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOps;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.NotGiven$;

public final class CSVRenderer<F> {
    private final CSVConfig config;
    private final RaiseThrowable<F> evidence$1;
    private final String sfd;
    private final String srd;
    private final String sq;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CSVRenderer$.class.getDeclaredField("config$lzy1"));

    public static <F> CSVRenderer<F> apply(RaiseThrowable<F> raiseThrowable) {
        return CSVRenderer$.MODULE$.apply(raiseThrowable);
    }

    public CSVRenderer(CSVConfig config, RaiseThrowable<F> evidence$1) {
        this.config = config;
        this.evidence$1 = evidence$1;
        this.sfd = BoxesRunTime.boxToCharacter((char)config.fieldDelimiter()).toString();
        this.srd = BoxesRunTime.boxToCharacter((char)config.recordDelimiter()).toString();
        this.sq = BoxesRunTime.boxToCharacter((char)config.quoteMark()).toString();
    }

    public Function1<Stream<F, Record>, Stream<F, Object>> render(Header header) {
        return (Function1 & Serializable)in -> {
            Stream hs = this.config.hasHeader() ? Stream$.MODULE$.emit(this.renderHeader(header)) : Stream$.MODULE$.empty();
            Stream cs = in.map((Function1 & Serializable)_$2 -> this.renderRow((Record)_$2, header));
            Stream stream = hs.$plus$plus(() -> CSVRenderer.$anonfun$2(cs));
            return stream.through(this.toChars());
        };
    }

    public Function1<Stream<F, Record>, Stream<F, Object>> render() {
        return (Function1 & Serializable)in -> {
            Stream stream = Stream$.MODULE$.InvariantOps(in);
            Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
            Pull pull = Stream.ToPull$.MODULE$.uncons1$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Option option = x$1;
                if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                    Record r = (Record)tuple2._1();
                    Stream t = (Stream)tuple2._2();
                    Pull headerRow = this.config.hasHeader() ? Pull$.MODULE$.output1(this.renderHeader(r.header())) : Pull$.MODULE$.pure((Object)BoxedUnit.UNIT);
                    Pull firstRow = Pull$.MODULE$.output1(this.renderRow(r, r.header()));
                    return headerRow.$greater$greater(() -> CSVRenderer.$anonfun$3$$anonfun$1(firstRow)).$greater$greater(() -> this.$anonfun$3$$anonfun$2(r, t));
                }
                if (None$.MODULE$.equals(option)) {
                    return Pull$.MODULE$.done();
                }
                throw new MatchError((Object)option);
            });
            Pull pull2 = Pull$.MODULE$.StreamPullOps(pull);
            return Pull.StreamPullOps$.MODULE$.stream$extension(pull2).through(this.toChars());
        };
    }

    public Function1<Stream<F, Record>, Stream<F, String>> rows() {
        return (Function1 & Serializable)in -> in.map((Function1 & Serializable)_$4 -> ((IterableOnceOps)_$4.values().map((Function1 & Serializable)s -> this.escape((String)s))).mkString(this.sfd));
    }

    private Function1<Stream<F, Either<HeaderError, String>>, Stream<F, Object>> toChars() {
        return (Function1 & Serializable)in -> in.rethrow((.less.colon.less)$less$colon$less$.MODULE$.refl(), this.evidence$1).intersperse((Object)this.srd).map((Function1 & Serializable)s -> Chunk$.MODULE$.array((Object)s.toCharArray(), ClassTag$.MODULE$.apply(Character.TYPE))).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.value());
    }

    private Either<HeaderError, String> renderRow(Record record, Header header) {
        return ((Either)((IndexedSeqOps)header.names().map((Function1 & Serializable)name -> record.apply((String)name).map((Function1 & Serializable)s -> this.escape((String)s)).toRight(() -> CSVRenderer.renderRow$$anonfun$1$$anonfun$2(name)))).foldRight((Object)package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil()), (Function2 & Serializable)(elm, seq) -> elm.flatMap((Function1 & Serializable)s -> seq.map((Function1 & Serializable)_$5 -> _$5.$colon$colon(s))))).map((Function1 & Serializable)_$6 -> _$6.mkString(this.sfd));
    }

    private Either<Nothing$, String> renderHeader(Header header) {
        IndexedSeq<String> remapped = this.config.headerMap().remap(header.names());
        return package$.MODULE$.Right().apply((Object)((IterableOnceOps)remapped.map((Function1 & Serializable)s -> this.escape((String)s))).mkString(this.sfd));
    }

    private String escape(String s) {
        String sdq = this.doubleQuotes(s);
        int sl = s.length();
        CSVConfig.EscapeMode escapeMode = this.config.escapeMode();
        if (CSVConfig$EscapeRequired$.MODULE$.equals(escapeMode)) {
            if (sdq.length() != sl || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), this.inline$config().fieldDelimiter()) || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), this.inline$config().recordDelimiter())) {
                return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(sdq), this.sq, "", this.sq);
            }
            return s;
        }
        if (CSVConfig$EscapeSpaces$.MODULE$.equals(escapeMode)) {
            if (sdq.length() != sl || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), this.inline$config().fieldDelimiter()) || StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(s), this.inline$config().recordDelimiter()) || s.strip().length() != sl) {
                return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(sdq), this.sq, "", this.sq);
            }
            return s;
        }
        if (CSVConfig$EscapeAll$.MODULE$.equals(escapeMode)) {
            return StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(sdq), this.sq, "", this.sq);
        }
        throw new MatchError((Object)escapeMode);
    }

    private String doubleQuotes(String s) {
        if (s.contains(this.sq)) {
            return s.replace(this.sq, StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString(this.sq), 2));
        }
        return s;
    }

    public final CSVConfig inline$config() {
        return this.config;
    }

    private static final Stream $anonfun$2(Stream cs$1) {
        return cs$1;
    }

    private final Pull loop$1$$anonfun$1$$anonfun$2(Header header$5, Stream t$1) {
        return this.loop$1(t$1, header$5);
    }

    private final Pull loop$1(Stream in, Header header) {
        Stream stream = Stream$.MODULE$.InvariantOps(in);
        Stream stream2 = new Stream.ToPull(Stream.InvariantOps$.MODULE$.pull$extension(stream)).fs2$Stream$ToPull$$self();
        return Stream.ToPull$.MODULE$.uncons$extension(stream2).flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2;
            Option option = x$1;
            if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                Chunk rc = (Chunk)tuple2._1();
                Stream t = (Stream)tuple2._2();
                return Pull$.MODULE$.output(rc.map((Function1 & Serializable)_$3 -> this.renderRow((Record)_$3, header))).$greater$greater(() -> this.loop$1$$anonfun$1$$anonfun$2(header, t));
            }
            if (None$.MODULE$.equals(option)) {
                return Pull$.MODULE$.done();
            }
            throw new MatchError((Object)option);
        });
    }

    private static final Pull $anonfun$3$$anonfun$1(Pull firstRow$1) {
        return firstRow$1;
    }

    private final Pull $anonfun$3$$anonfun$2(Record r$1, Stream t$2) {
        return this.loop$1(t$2, r$1.header());
    }

    private static final HeaderError renderRow$$anonfun$1$$anonfun$2(String name$1) {
        return new HeaderError(Position$.MODULE$.none(), FieldInfo$.MODULE$.apply(name$1));
    }
}

