/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.spata.io;

import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.RaiseThrowable;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files$;
import fs2.io.file.Flags$;
import fs2.io.file.Path$;
import fs2.io.package$;
import fs2.text$;
import info.fingo.spata.io.Reader$;
import info.fingo.spata.io.Reader$CSV$;
import info.fingo.spata.util.Logger;
import info.fingo.spata.util.Logger$;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.collection.Iterator;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.NotGiven$;

public interface Reader<F> {
    public static int defaultChunkSize() {
        return Reader$.MODULE$.defaultChunkSize();
    }

    public static <F> Plain<F> plain(int n, Sync<F> sync, Logger<F> logger) {
        return Reader$.MODULE$.plain(n, sync, logger);
    }

    public static <F> Plain<F> plain(Sync<F> sync, Logger<F> logger) {
        return Reader$.MODULE$.plain(sync, logger);
    }

    public static <F> Shifting<F> shifting(Async<F> async, Logger<F> logger) {
        return Reader$.MODULE$.shifting(async, logger);
    }

    public static <F> Shifting<F> shifting(int n, Async<F> async, Logger<F> logger) {
        return Reader$.MODULE$.shifting(n, async, logger);
    }

    public int chunkSize();

    public Stream<F, Object> read(Source var1);

    public Stream<F, Object> read(F var1, Codec var2);

    public Stream<F, Object> read(InputStream var1, Codec var2);

    public Stream<F, Object> read(Path var1, Codec var2);

    public static Stream apply$(Reader $this, Object csv, CSV evidence$1, Codec codec) {
        return $this.apply(csv, evidence$1, codec);
    }

    default public <A> Stream<F, Object> apply(A csv, CSV<A> evidence$1, Codec codec) {
        A a = csv;
        if (a instanceof Source) {
            Source s = (Source)a;
            return this.read(s);
        }
        if (a instanceof InputStream) {
            InputStream is = (InputStream)a;
            return this.read(is, codec);
        }
        if (a instanceof Path) {
            Path p = (Path)a;
            return this.read(p, codec);
        }
        throw new MatchError(a);
    }

    public static Stream apply$(Reader $this, Object fis, Codec codec) {
        return $this.apply(fis, codec);
    }

    default public Stream<F, Object> apply(F fis, Codec codec) {
        return this.read(fis, codec);
    }

    public static Function1 by$(Reader $this, CSV evidence$2, Codec codec) {
        return $this.by(evidence$2, codec);
    }

    default public <A> Function1<Stream<F, A>, Stream<F, Object>> by(CSV<A> evidence$2, Codec codec) {
        return (Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)_$3 -> this.apply(_$3, evidence$2, codec), NotGiven$.MODULE$.value());
    }

    public static interface CSV<A> {
        public static int ordinal(CSV<?> cSV) {
            return Reader$CSV$.MODULE$.ordinal(cSV);
        }
    }

    public static final class Plain<F>
    implements Reader<F> {
        private final int chunkSize;
        private final Sync<F> evidence$16;
        private final Logger<F> evidence$17;

        public Plain(int chunkSize, Sync<F> evidence$16, Logger<F> evidence$17) {
            this.chunkSize = chunkSize;
            this.evidence$16 = evidence$16;
            this.evidence$17 = evidence$17;
        }

        @Override
        public int chunkSize() {
            return this.chunkSize;
        }

        @Override
        public Stream<F, Object> read(Source source) {
            return Logger$.MODULE$.apply(this.evidence$17).debugS((Function0<String>)((Function0 & Serializable)this::read$$anonfun$1)).$greater$greater(() -> this.read$$anonfun$2(source), NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> read(F fis, Codec codec) {
            return Stream$.MODULE$.eval(fis).flatMap((Function1 & Serializable)is -> this.read((Source)new BufferedSource(is, this.chunkSize(), codec)), NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> read(InputStream is, Codec codec) {
            return this.read((Source)new BufferedSource(is, this.chunkSize(), codec));
        }

        @Override
        public Stream<F, Object> read(Path path, Codec codec) {
            return Stream$.MODULE$.bracket(package.all$.MODULE$.catsSyntaxApply(Logger$.MODULE$.apply(this.evidence$17).debug((Function0<String>)((Function0 & Serializable)() -> this.read$$anonfun$4(path))), this.evidence$16).$times$greater(cats.effect.package$.MODULE$.Sync().apply(this.evidence$16).delay(() -> this.read$$anonfun$5(path, codec))), (Function1 & Serializable)source -> cats.effect.package$.MODULE$.Sync().apply(this.evidence$16).delay((Function0 & Serializable)() -> {
                this.read$$anonfun$6$$anonfun$1((BufferedSource)source);
                return BoxedUnit.UNIT;
            })).flatMap((Function1 & Serializable)source -> this.read((Source)source), NotGiven$.MODULE$.value());
        }

        private final String read$$anonfun$1() {
            return "Reading data on current thread";
        }

        private final Stream read$$anonfun$2(Source source$1) {
            boolean bl = Stream$.MODULE$.fromIterator();
            return Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl, (Iterator)source$1, this.chunkSize(), this.evidence$16).through(Reader$.MODULE$.info$fingo$spata$io$Reader$$$skipBom(this.evidence$17, Codec$.MODULE$.fallbackSystemCodec()));
        }

        private final String read$$anonfun$4(Path path$1) {
            return "Path " + path$1 + " provided as input";
        }

        private final BufferedSource read$$anonfun$5(Path path$2, Codec codec$5) {
            return Source$.MODULE$.fromInputStream(Files.newInputStream(path$2, StandardOpenOption.READ), codec$5);
        }

        private final void read$$anonfun$6$$anonfun$1(BufferedSource source$2) {
            source$2.close();
        }
    }

    public static final class Shifting<F>
    implements Reader<F> {
        private final int chunkSize;
        private final Async<F> evidence$18;
        private final Logger<F> evidence$19;
        private final RaiseThrowable<F> evidence$20;

        public Shifting(int chunkSize, Async<F> evidence$18, Logger<F> evidence$19, RaiseThrowable<F> evidence$20) {
            this.chunkSize = chunkSize;
            this.evidence$18 = evidence$18;
            this.evidence$19 = evidence$19;
            this.evidence$20 = evidence$20;
        }

        @Override
        public int chunkSize() {
            return this.chunkSize;
        }

        @Override
        public Stream<F, Object> read(Source source) {
            return Logger$.MODULE$.apply(this.evidence$19).debugS((Function0<String>)((Function0 & Serializable)this::read$$anonfun$8)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                boolean bl = Stream$.MODULE$.fromBlockingIterator();
                return Stream.PartiallyAppliedFromBlockingIterator$.MODULE$.apply$extension(bl, (Iterator)source, this.chunkSize(), this.evidence$18).through(Reader$.MODULE$.info$fingo$spata$io$Reader$$$skipBom(this.evidence$19, Codec$.MODULE$.fallbackSystemCodec())).map((Function1 & Serializable)object -> this.read$$anonfun$9$$anonfun$1(BoxesRunTime.unboxToChar((Object)object)));
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> read(F fis, Codec codec) {
            return Logger$.MODULE$.apply(this.evidence$19).debugS((Function0<String>)((Function0 & Serializable)this::read$$anonfun$10)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return package$.MODULE$.readInputStream(fis, this.chunkSize(), Reader$.info$fingo$spata$io$Reader$$$autoClose, this.evidence$18).through(this.byte2char(codec)).map((Function1 & Serializable)object -> this.read$$anonfun$11$$anonfun$1(BoxesRunTime.unboxToChar((Object)object)));
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Stream<F, Object> read(InputStream is, Codec codec) {
            return this.read(cats.effect.package$.MODULE$.Sync().apply(this.evidence$18).delay(() -> this.read$$anonfun$12(is)), codec);
        }

        @Override
        public Stream<F, Object> read(Path path, Codec codec) {
            return Logger$.MODULE$.apply(this.evidence$19).debugS((Function0<String>)((Function0 & Serializable)() -> this.read$$anonfun$13(path))).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Files$.MODULE$.forAsync(this.evidence$18).readAll(Path$.MODULE$.fromNioPath(path), this.chunkSize(), Flags$.MODULE$.Read()).through(this.byte2char(codec)).map((Function1 & Serializable)object -> this.read$$anonfun$14$$anonfun$1(BoxesRunTime.unboxToChar((Object)object)));
            }, NotGiven$.MODULE$.value());
        }

        private Function1<Stream<F, Object>, Stream<F, Object>> byte2char(Codec codec) {
            return (Function1 & Serializable)_$14 -> _$14.through(text$.MODULE$.decodeWithCharset(codec.charSet(), this.evidence$20)).chunks().map((Function1 & Serializable)_$15 -> _$15.flatMap((Function1 & Serializable)s -> this.s2cc((String)s))).flatMap((Function1 & Serializable)os -> Stream$.MODULE$.chunk(os), NotGiven$.MODULE$.value()).through(Reader$.MODULE$.info$fingo$spata$io$Reader$$$skipBom(this.evidence$19, codec));
        }

        private Chunk<Object> s2cc(String s) {
            return Chunk$.MODULE$.charBuffer(CharBuffer.wrap(s));
        }

        private final String read$$anonfun$8() {
            return "Reading data from Source with thread shifting";
        }

        private final /* synthetic */ char read$$anonfun$9$$anonfun$1(char c) {
            return c;
        }

        private final String read$$anonfun$10() {
            return "Reading data from InputStream with thread shifting";
        }

        private final /* synthetic */ char read$$anonfun$11$$anonfun$1(char c) {
            return c;
        }

        private final InputStream read$$anonfun$12(InputStream is$1) {
            return is$1;
        }

        private final String read$$anonfun$13(Path path$3) {
            return "Reading data from path " + path$3 + " with thread shifting";
        }

        private final /* synthetic */ char read$$anonfun$14$$anonfun$1(char c) {
            return c;
        }
    }
}

