/*
 * Decompiled with CFR 0.152.
 */
package info.fingo.spata.io;

import cats.Foldable;
import cats.Show$;
import cats.effect.kernel.Async;
import cats.effect.kernel.Sync;
import cats.syntax.FoldableOps0$;
import cats.syntax.package;
import fs2.Chunk;
import fs2.Chunk$;
import fs2.Stream;
import fs2.Stream$;
import fs2.io.file.Files$;
import fs2.io.file.Flags$;
import fs2.io.file.Path$;
import fs2.io.package$;
import fs2.text$;
import info.fingo.spata.io.Writer$;
import info.fingo.spata.io.Writer$CSV$;
import info.fingo.spata.util.Logger;
import info.fingo.spata.util.Logger$;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.io.Codec;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.util.NotGiven$;

public interface Writer<F> {
    public static <F> Plain<F> plain(Sync<F> sync, Logger<F> logger) {
        return Writer$.MODULE$.plain(sync, logger);
    }

    public static <F> Shifting<F> shifting(Async<F> async, Logger<F> logger) {
        return Writer$.MODULE$.shifting(async, logger);
    }

    public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(F var1, Codec var2);

    public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(OutputStream var1, Codec var2);

    public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(Path var1, Codec var2);

    public static Function1 apply$(Writer $this, Object csv, CSV evidence$1, Codec codec) {
        return $this.apply(csv, evidence$1, codec);
    }

    default public <A> Function1<Stream<F, Object>, Stream<F, BoxedUnit>> apply(A csv, CSV<A> evidence$1, Codec codec) {
        A a = csv;
        if (a instanceof OutputStream) {
            OutputStream os = (OutputStream)a;
            return this.write(os, codec);
        }
        if (a instanceof Path) {
            Path p = (Path)a;
            return this.write(p, codec);
        }
        throw new MatchError(a);
    }

    public static Function1 apply$(Writer $this, Object csv, Codec codec) {
        return $this.apply(csv, codec);
    }

    default public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> apply(F csv, Codec codec) {
        return this.write(csv, codec);
    }

    public static interface CSV<A> {
        public static int ordinal(CSV<?> cSV) {
            return Writer$CSV$.MODULE$.ordinal(cSV);
        }
    }

    public static final class Plain<F>
    implements Writer<F> {
        private final Sync<F> evidence$8;
        private final Logger<F> evidence$9;

        public Plain(Sync<F> evidence$8, Logger<F> evidence$9) {
            this.evidence$8 = evidence$8;
            this.evidence$9 = evidence$9;
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(F fos, Codec codec) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.eval(fos).flatMap((Function1 & Serializable)os -> in.through(this.write((OutputStream)os, codec)), NotGiven$.MODULE$.value());
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(OutputStream os, Codec codec) {
            return (Function1 & Serializable)in -> in.through(this.char2byte(codec)).evalMap((Function1 & Serializable)c -> cats.effect.package$.MODULE$.Sync().apply(this.evidence$8).delay((Function0 & Serializable)() -> {
                this.write$$anonfun$2$$anonfun$1$$anonfun$1(os, (Chunk)c);
                return BoxedUnit.UNIT;
            })).$plus$plus(() -> this.write$$anonfun$2$$anonfun$2(os));
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(Path path, Codec codec) {
            return (Function1 & Serializable)in -> Stream$.MODULE$.bracket(package.all$.MODULE$.catsSyntaxApply(Logger$.MODULE$.apply(this.evidence$9).debug((Function0<String>)((Function0 & Serializable)() -> this.write$$anonfun$3$$anonfun$1(path))), this.evidence$8).$times$greater(cats.effect.package$.MODULE$.Sync().apply(this.evidence$8).delay(() -> this.write$$anonfun$3$$anonfun$2(path))), (Function1 & Serializable)os -> cats.effect.package$.MODULE$.Sync().apply(this.evidence$8).delay((Function0 & Serializable)() -> {
                this.write$$anonfun$3$$anonfun$3$$anonfun$1((OutputStream)os);
                return BoxedUnit.UNIT;
            })).flatMap((Function1 & Serializable)os -> in.through(this.write((OutputStream)os, codec)), NotGiven$.MODULE$.value());
        }

        public Function1<Stream<F, Object>, Stream<F, Chunk<Object>>> char2byte(Codec codec) {
            return (Function1 & Serializable)in -> in.chunks().map((Function1 & Serializable)_$6 -> {
                Chunk chunk = (Chunk)package.all$.MODULE$.catsSyntaxFoldableOps0(_$6);
                return FoldableOps0$.MODULE$.mkString_$extension((Object)chunk, "", Show$.MODULE$.catsShowForChar(), (Foldable)Chunk$.MODULE$.instance());
            }).through(text$.MODULE$.encodeC(codec.charSet()));
        }

        private final void write$$anonfun$2$$anonfun$1$$anonfun$1(OutputStream os$3, Chunk c$1) {
            os$3.write((byte[])c$1.toArray(ClassTag$.MODULE$.apply(Byte.TYPE)));
        }

        private final void write$$anonfun$2$$anonfun$2$$anonfun$1(OutputStream os$5) {
            os$5.flush();
        }

        private final Stream write$$anonfun$2$$anonfun$2(OutputStream os$4) {
            return Stream$.MODULE$.eval(cats.effect.package$.MODULE$.Sync().apply(this.evidence$8).delay((Function0 & Serializable)() -> {
                this.write$$anonfun$2$$anonfun$2$$anonfun$1(os$4);
                return BoxedUnit.UNIT;
            }));
        }

        private final String write$$anonfun$3$$anonfun$1(Path path$2) {
            return "Path " + path$2 + " provided as output";
        }

        private final OutputStream write$$anonfun$3$$anonfun$2(Path path$3) {
            return Files.newOutputStream(path$3, (StandardOpenOption[])Arrays$.MODULE$.seqToArray(Writer$.info$fingo$spata$io$Writer$$$openOptions, StandardOpenOption.class));
        }

        private final void write$$anonfun$3$$anonfun$3$$anonfun$1(OutputStream os$6) {
            os$6.close();
        }
    }

    public static final class Shifting<F>
    implements Writer<F> {
        private final Async<F> evidence$10;
        private final Logger<F> evidence$11;

        public Shifting(Async<F> evidence$10, Logger<F> evidence$11) {
            this.evidence$10 = evidence$10;
            this.evidence$11 = evidence$11;
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(F fos, Codec codec) {
            return (Function1 & Serializable)in -> Logger$.MODULE$.apply(this.evidence$11).debugS((Function0<String>)((Function0 & Serializable)this::write$$anonfun$4$$anonfun$1)).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Stream stream = Stream$.MODULE$.NothingStreamOps(in.through(this.char2byte(codec)).through(package$.MODULE$.writeOutputStream(fos, Writer$.info$fingo$spata$io$Writer$$$autoClose, this.evidence$10)));
                return Stream.NothingStreamOps$.MODULE$.unitary$extension(stream).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }, NotGiven$.MODULE$.value());
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(OutputStream os, Codec codec) {
            return this.write(cats.effect.package$.MODULE$.Sync().apply(this.evidence$10).delay(() -> this.write$$anonfun$5(os)), codec);
        }

        @Override
        public Function1<Stream<F, Object>, Stream<F, BoxedUnit>> write(Path path, Codec codec) {
            return (Function1 & Serializable)in -> Logger$.MODULE$.apply(this.evidence$11).debugS((Function0<String>)((Function0 & Serializable)() -> this.write$$anonfun$6$$anonfun$1(path))).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                Stream stream = Stream$.MODULE$.NothingStreamOps(in.through(this.char2byte(codec)).through(Files$.MODULE$.forAsync(this.evidence$10).writeAll(Path$.MODULE$.fromNioPath(path), Flags$.MODULE$.fromOpenOptions(Writer$.info$fingo$spata$io$Writer$$$openOptions))));
                return Stream.NothingStreamOps$.MODULE$.unitary$extension(stream).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }, NotGiven$.MODULE$.value());
        }

        public Function1<Stream<F, Object>, Stream<F, Object>> char2byte(Codec codec) {
            return (Function1 & Serializable)_$8 -> _$8.chunks().map((Function1 & Serializable)_$9 -> {
                Chunk chunk = (Chunk)package.all$.MODULE$.catsSyntaxFoldableOps0(_$9);
                return FoldableOps0$.MODULE$.mkString_$extension((Object)chunk, "", Show$.MODULE$.catsShowForChar(), (Foldable)Chunk$.MODULE$.instance());
            }).through(text$.MODULE$.encode(codec.charSet()));
        }

        private final String write$$anonfun$4$$anonfun$1() {
            return "Writing data to OutputStream with thread shifting";
        }

        private final OutputStream write$$anonfun$5(OutputStream os$7) {
            return os$7;
        }

        private final String write$$anonfun$6$$anonfun$1(Path path$5) {
            return "Writing data to path " + path$5 + " with thread shifting";
        }
    }
}

