/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import info.freelibrary.util.FileUtils;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;

@Mojo(name="set-cpumem-properties", defaultPhase=LifecyclePhase.VALIDATE)
public class CPUandMemoryMojo
extends AbstractMojo {
    public static final String SYSTEM_CORES = "system.cores";
    public static final String SYSTEM_FREE_MEMORY = "system.free.memory";
    public static final String SYSTEM_TOTAL_MEMORY = "system.total.memory";
    private static final Logger LOGGER = LoggerFactory.getLogger(CPUandMemoryMojo.class);
    @Parameter(defaultValue="${project}")
    protected MavenProject myProject;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Properties properties = this.myProject.getProperties();
        int cores = Runtime.getRuntime().availableProcessors();
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hal = si.getHardware();
        GlobalMemory memory = hal.getMemory();
        properties.setProperty(SYSTEM_CORES, Integer.toString(cores));
        properties.setProperty(SYSTEM_FREE_MEMORY, this.sizeToString(memory.getAvailable()));
        properties.setProperty(SYSTEM_TOTAL_MEMORY, this.sizeToString(memory.getTotal()));
    }

    private String sizeToString(long aSizeInBytes) {
        String size = FileUtils.sizeFromBytes(aSizeInBytes, true).replace(" ", "");
        return size.substring(0, size.length() - 1);
    }
}

