/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import info.freelibrary.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-file-perms")
public class FilePermissionsMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject myProject;
    @Parameter(alias="perms")
    private int myPerms;
    @Parameter(alias="file")
    private File myFile;
    @Parameter(alias="files")
    private List<String> myFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Set<PosixFilePermission> perms = FileUtils.convertToPermissionsSet(this.myPerms);
        try {
            if (this.myFile != null) {
                Files.setPosixFilePermissions(this.myFile.toPath(), perms);
            } else if (this.myFiles != null) {
                Iterator<String> iterator = this.myFiles.iterator();
                while (iterator.hasNext()) {
                    Files.setPosixFilePermissions(new File(iterator.next()).toPath(), perms);
                }
            }
        }
        catch (IOException details) {
            throw new MojoExecutionException(details.getMessage(), (Exception)details);
        }
    }
}

