/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaInterfaceSource;

@Mojo(name="generate-codes", defaultPhase=LifecyclePhase.VALIDATE)
public class I18nCodesMojo
extends AbstractMojo {
    private static final String MESSAGE_CLASS_NAME = "message-class-name";
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nCodesMojo.class, "freelib-utils_messages");
    @Parameter(defaultValue="${project}")
    protected MavenProject myProject;
    @Parameter(alias="messageFiles", property="messageFiles")
    private List<String> myPropertyFiles;
    @Parameter(alias="generatedSourcesDirectory", property="generatedSourcesDirectory")
    private File myGeneratedSrcDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.myPropertyFiles != null) {
            Iterator<String> iterator = this.myPropertyFiles.iterator();
            Properties properties = new Properties();
            while (iterator.hasNext()) {
                FileInputStream inStream = null;
                try {
                    String srcFolderName;
                    inStream = new FileInputStream(iterator.next());
                    properties.loadFromXML(inStream);
                    String fullClassName = properties.getProperty(MESSAGE_CLASS_NAME);
                    String string = srcFolderName = this.myGeneratedSrcDir == null ? this.myProject.getBuild().getSourceDirectory() : this.myGeneratedSrcDir.getAbsolutePath();
                    if (fullClassName != null) {
                        Iterator<String> messageIterator = properties.stringPropertyNames().iterator();
                        String[] nameParts = fullClassName.split("\\.");
                        int classNameIndex = nameParts.length - 1;
                        String className = nameParts[classNameIndex];
                        Object[] packageParts = Arrays.copyOfRange(nameParts, 0, classNameIndex);
                        String packageName = StringUtils.join((Object[])packageParts, (String)".");
                        JavaInterfaceSource java = (JavaInterfaceSource)Roaster.create(JavaInterfaceSource.class);
                        File packageDirectory = new File(srcFolderName + File.separatorChar + packageName.replace('.', File.separatorChar));
                        if (!packageDirectory.exists() && !packageDirectory.mkdirs()) {
                            throw new MojoExecutionException(LOGGER.getMessage("MVN-MESSAGE-003", packageDirectory, className));
                        }
                        while (messageIterator.hasNext()) {
                            String key = messageIterator.next();
                            if (key.equals(MESSAGE_CLASS_NAME)) continue;
                            String normalizedKey = key.replaceAll("[\\.-]", "_");
                            String value = properties.getProperty(key);
                            FieldSource field = java.addField();
                            ((FieldSource)field.setName(normalizedKey)).setStringInitializer(key);
                            ((FieldSource)((FieldSource)field.setType("String").setPublic()).setStatic(true)).setFinal(true);
                            field.getJavaDoc().setFullText("Message: " + value);
                        }
                        File javaFile = new File(packageDirectory, className + ".java");
                        FileWriter javaWriter = new FileWriter(javaFile);
                        java.getJavaDoc().setFullText("BEGIN GENERATED CODE");
                        ((JavaInterfaceSource)java.setPackage(packageName)).setName(className);
                        javaWriter.write(java.toString());
                        javaWriter.close();
                        continue;
                    }
                    if (!LOGGER.isWarnEnabled()) continue;
                    LOGGER.warn("MVN-MESSAGE-002", (Object)MESSAGE_CLASS_NAME);
                }
                catch (IOException details) {
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error(details.getMessage(), details);
                    }
                    IOUtils.closeQuietly(inStream);
                }
            }
        } else if (LOGGER.isWarnEnabled()) {
            LOGGER.warn("MVN-MESSAGE-001");
        }
    }
}

