/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import info.freelibrary.maven.MavenUtils;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="configure-logging")
public class MavenLoggingMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenLoggingMojo.class);
    @Parameter
    private List<String> myExcludedLoggerNames;
    @Parameter
    private List<String> myIncludedLoggerNames;
    @Parameter(property="level", defaultValue="error")
    private String myLevel;

    public void execute() throws MojoExecutionException, MojoFailureException {
        int level = MavenUtils.getLevelIntCode(this.myLevel);
        if (LOGGER.isWarnEnabled() && level == 0) {
            LOGGER.warn("Supplied log level '{}' was unknown, setting level to 'ERROR'", (Object)this.myLevel);
        }
        MavenUtils.setLogLevels(level == 0 ? 40 : level, MavenUtils.getMavenLoggers());
    }
}

