/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenUtils.class);
    public static final int ERROR_LOG_LEVEL = 40;
    public static final int WARN_LOG_LEVEL = 30;
    public static final int INFO_LOG_LEVEL = 20;
    public static final int DEBUG_LOG_LEVEL = 10;
    public static final int TRACE_LOG_LEVEL = 0;

    private MavenUtils() {
    }

    public static final void setLogLevels(int aLogLevel, String ... aLoggerList) {
        MavenUtils.setLogLevels(aLogLevel, aLoggerList, null, null);
    }

    public static final void setLogLevels(int aLogLevel, String[] aLoggerList, String[] aExcludesList, String[] aIncludesList) {
        ArrayList<String> loggerList = new ArrayList<String>(Arrays.asList(aLoggerList));
        Class<?> simpleLogger = LoggerFactory.getLogger((String)"org.slf4j.impl.SimpleLogger").getClass();
        if (aIncludesList != null) {
            loggerList.addAll(Arrays.asList(aIncludesList));
        }
        for (String loggerName : loggerList) {
            Logger loggerObject;
            Class<?> loggerClass;
            if (aExcludesList != null) {
                boolean skip = false;
                for (int index = 0; index < aExcludesList.length; ++index) {
                    if (!loggerName.equals(aExcludesList[index])) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
            }
            if (simpleLogger.equals(loggerClass = (loggerObject = LoggerFactory.getLogger((String)loggerName)).getClass())) {
                try {
                    Field field = loggerClass.getDeclaredField("currentLogLevel");
                    field.setAccessible(true);
                    field.setInt(loggerObject, aLogLevel);
                    if (!loggerObject.isDebugEnabled()) continue;
                    LOGGER.debug("'{}' logging level is now set to: {}", (Object)loggerName, (Object)MavenUtils.getLevelName(aLogLevel));
                }
                catch (IllegalAccessException | NoSuchFieldException details) {
                    LOGGER.error("Has the Maven logger changed?", (Throwable)details);
                }
                continue;
            }
            if (!LOGGER.isWarnEnabled()) continue;
            LOGGER.warn("Supplied logger '{}' isn't a org.slf4j.impl.SimpleLogger", (Object)loggerName);
        }
    }

    public static final String[] getMavenLoggers() {
        return new String[]{"org.apache.maven.cli.event.ExecutionEventLogger", "org.apache.maven.tools.plugin.scanner.DefaultMojoScanner", "org.apache.maven.plugin.plugin.DescriptorGeneratorMojo", "org.apache.maven.plugin.dependency.fromConfiguration.UnpackMojo", "org.apache.maven.shared.filtering.DefaultMavenResourcesFiltering", "org.apache.maven.plugin.checkstyle.CheckstyleViolationCheckMojo", "org.apache.maven.plugin.clean.CleanMojo", "org.apache.maven.tools.plugin.annotations.JavaAnnotationsMojoDescriptorExtractor", "org.apache.maven.plugin.failsafe.VerifyMojo", "org.apache.maven.DefaultMaven", "org.apache.maven.plugin.compiler.TestCompilerMojo", "org.apache.maven.plugins.enforcer.EnforceMojo", "org.apache.maven.plugin.compiler.CompilerMojo", "org.codehaus.plexus.archiver.jar.JarArchiver", "org.apache.maven.plugin.surefire.SurefirePlugin", "org.apache.maven.plugin.failsafe.IntegrationTestMojo"};
    }

    public static final String getLevelName(int aLogLevel) {
        switch (aLogLevel) {
            case 40: {
                return "ERROR";
            }
            case 30: {
                return "WARN";
            }
            case 20: {
                return "INFO";
            }
            case 10: {
                return "DEBUG";
            }
            case 0: {
                return "TRACE";
            }
        }
        return "UNKNOWN";
    }

    public static final int getLevelIntCode(String aLogLevelName) {
        String levelName = aLogLevelName.trim().toLowerCase();
        if (levelName.equals("error")) {
            return 40;
        }
        if (levelName.equals("warn")) {
            return 30;
        }
        if (levelName.equals("info")) {
            return 20;
        }
        if (levelName.equals("debug")) {
            return 10;
        }
        if (levelName.equals("trace")) {
            return 0;
        }
        return 0;
    }
}

