/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.maven;

import java.util.UUID;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="set-uuid-property", defaultPhase=LifecyclePhase.VALIDATE)
public class UUIDGeneratingMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(UUIDGeneratingMojo.class);
    @Parameter(defaultValue="${project}")
    protected MavenProject myProject;
    @Parameter(alias="string")
    private String myString;
    @Parameter(alias="name", defaultValue="uuid")
    private String myName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String uuid;
        String string = uuid = this.myString == null ? UUID.randomUUID().toString() : UUID.fromString(this.myString).toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Setting a UUID property ({} = {}) for use in the Maven build", (Object)this.myName, (Object)uuid);
        }
        this.myProject.getProperties().setProperty(this.myName, uuid);
    }
}

