/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;

public class FileExtFileFilter
implements FilenameFilter {
    private final String[] myExtensions;

    public FileExtFileFilter(String aFileExt) {
        this.myExtensions = new String[]{this.normalizeExt(aFileExt)};
    }

    public FileExtFileFilter(String ... aFileExtList) {
        this.myExtensions = new String[aFileExtList.length];
        for (int index = 0; index < aFileExtList.length; ++index) {
            this.myExtensions[index] = this.normalizeExt(aFileExtList[index]);
        }
    }

    public String toString() {
        return Arrays.toString(this.myExtensions);
    }

    @Override
    public boolean accept(File aDir, String aFileName) {
        for (String extension : this.myExtensions) {
            if (!new File(aDir, aFileName).isFile() || !aFileName.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    public boolean filters(String aFileExt) {
        String normalizedExt = this.normalizeExt(aFileExt);
        for (String extension : this.myExtensions) {
            if (!extension.equals(normalizedExt)) continue;
            return true;
        }
        return false;
    }

    private String normalizeExt(String aFileExt) {
        return "." + (aFileExt.startsWith(".") ? aFileExt.substring(1) : aFileExt);
    }
}

