/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.DOMUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.RegexDirFilter;
import info.freelibrary.util.RegexFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.attribute.PosixFilePermission;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FileUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final String DIR_TYPE = "dir";
    private static final String FILE_TYPE = "file";
    private static final String FILE_PATH = "path";
    private static final String MODIFIED = "modified";
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String toXML(String aFilePath) throws FileNotFoundException, TransformerException {
        return FileUtils.toXML(aFilePath, ".*");
    }

    public static Element toElement(String aFilePath) throws FileNotFoundException, ParserConfigurationException {
        return FileUtils.toElement(aFilePath, ".*");
    }

    public static Element toElement(String aFilePath, boolean aBool) throws FileNotFoundException, ParserConfigurationException {
        return FileUtils.toElement(aFilePath, ".*", aBool);
    }

    public static Document toDocument(String aFilePath) throws FileNotFoundException, ParserConfigurationException {
        return FileUtils.toDocument(aFilePath, ".*");
    }

    public static String toXML(String aFilePath, String aPattern) throws FileNotFoundException, TransformerException {
        return FileUtils.toXML(aFilePath, aPattern, false);
    }

    public static String toXML(String aFilePath, boolean aDeepConversion) throws FileNotFoundException, TransformerException {
        return FileUtils.toXML(aFilePath, ".*", aDeepConversion);
    }

    public static String toXML(String aFilePath, String aPattern, boolean aDeepTransformation) throws FileNotFoundException, TransformerException {
        Element element = FileUtils.toElement(aFilePath, aPattern, aDeepTransformation);
        return DOMUtils.toXML(element);
    }

    public static Map<String, List<String>> toHashMap(String aFilePath) throws FileNotFoundException {
        return FileUtils.toHashMap(aFilePath, null, null);
    }

    public static Map<String, List<String>> toHashMap(String aFilePath, String aPattern) throws FileNotFoundException {
        return FileUtils.toHashMap(aFilePath, aPattern, null);
    }

    public static Map<String, List<String>> toHashMap(String aFilePath, String aPattern, String ... aIgnoreList) throws RuntimeException, FileNotFoundException {
        String filePattern = aPattern != null ? aPattern : ".*";
        RegexFileFilter filter = new RegexFileFilter(filePattern);
        HashMap fileMap = new HashMap();
        File source = new File(aFilePath);
        for (File file : FileUtils.listFiles(source, filter, true, aIgnoreList)) {
            String fileName = file.getName();
            String filePath = file.getAbsolutePath();
            if (fileMap.containsKey(fileName)) {
                List paths = (List)fileMap.get(fileName);
                if (!paths.contains(filePath)) {
                    paths.add(filePath);
                    continue;
                }
                throw new RuntimeException("Duplicate file path name");
            }
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(filePath);
            fileMap.put(fileName, pathList);
        }
        return Collections.unmodifiableMap(fileMap);
    }

    public static Element toElement(String aFilePath, String aPattern) throws FileNotFoundException, ParserConfigurationException {
        return FileUtils.toElement(aFilePath, aPattern, false);
    }

    public static Element toElement(String aFilePath, String aPattern, boolean aDeepTransformation) throws FileNotFoundException {
        RegexFileFilter filter = new RegexFileFilter(aPattern);
        File file = new File(aFilePath);
        if (file.exists() && file.canRead()) {
            return FileUtils.add(file, null, filter, aDeepTransformation);
        }
        throw new FileNotFoundException(aFilePath);
    }

    public static Document toDocument(String aFilePath, String aPattern) throws FileNotFoundException, ParserConfigurationException {
        return FileUtils.toDocument(aFilePath, aPattern, false);
    }

    public static Document toDocument(String aFilePath, String aPattern, boolean aDeepConversion) throws FileNotFoundException, ParserConfigurationException {
        Element element = FileUtils.toElement(aFilePath, aPattern, aDeepConversion);
        Document document = element.getOwnerDocument();
        document.appendChild(element);
        return document;
    }

    public static File toFile(URL aURL) throws MalformedURLException {
        if (aURL.getProtocol().equals(FILE_TYPE)) {
            return new File(aURL.toString().replace("file:", ""));
        }
        throw new MalformedURLException("Not a file URL");
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter) throws FileNotFoundException {
        return FileUtils.listFiles(aDir, aFilter, false, null);
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter, boolean aDeepListing) throws FileNotFoundException {
        return FileUtils.listFiles(aDir, aFilter, aDeepListing, null);
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter, boolean aDeepListing, String ... aIgnoreList) throws FileNotFoundException {
        if (!aDir.exists()) {
            throw new FileNotFoundException(aDir.getAbsolutePath());
        }
        if (aDir.isFile()) {
            if (aFilter.accept(aDir.getParentFile(), aDir.getName())) {
                return new File[]{aDir};
            }
            return new File[0];
        }
        if (!aDeepListing) {
            return aDir.listFiles(aFilter);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        Object[] ignoreList = aIgnoreList == null ? new String[]{} : aIgnoreList;
        for (File file : aDir.listFiles()) {
            String fileName = file.getName();
            if (aFilter.accept(aDir, fileName)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Match file: {}", (Object)file);
                }
                fileList.add(file);
            }
            if (!file.isDirectory() || Arrays.binarySearch(ignoreList, fileName) >= 0) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Descending into: {}", (Object)file);
            }
            File[] files = FileUtils.listFiles(file, aFilter, aDeepListing);
            fileList.addAll(Arrays.asList(files));
        }
        return fileList.toArray(new File[fileList.size()]);
    }

    public static String stripExt(File aFile) {
        return FileUtils.stripExt(aFile.getName());
    }

    public static String stripExt(String aFileName) {
        int index = aFileName.lastIndexOf(46);
        if (index != -1) {
            return aFileName.substring(0, index);
        }
        return aFileName;
    }

    public static String getExt(String aFileName) {
        int index = aFileName.lastIndexOf(46);
        if (index != -1) {
            return aFileName.substring(index + 1, aFileName.length());
        }
        return "";
    }

    public static long getSize(File aFile) {
        long size = 0L;
        if (aFile != null && aFile.exists()) {
            if (aFile.isDirectory()) {
                for (File file : aFile.listFiles()) {
                    size += FileUtils.getSize(file);
                }
            } else {
                size += aFile.length();
            }
        }
        return size;
    }

    public static boolean delete(File aDir) {
        if (aDir.exists() && aDir.listFiles() != null) {
            for (File file : aDir.listFiles()) {
                if (file.isDirectory()) {
                    if (FileUtils.delete(file) || !LOGGER.isErrorEnabled()) continue;
                    LOGGER.error("Unable to delete: " + file);
                    continue;
                }
                if (file.delete() || !LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Unable to delete: " + file);
            }
        } else if (LOGGER.isDebugEnabled() && aDir.listFiles() == null) {
            LOGGER.debug("Trying to delete '{}' but there was a problem", (Object)aDir);
        }
        return aDir.delete();
    }

    public static void copy(File aFromFile, File aToFile) throws IOException {
        if (aFromFile.isDirectory() && aToFile.isFile() || aFromFile.isFile() && aToFile.isDirectory()) {
            throw new IOException("Can't copy file to directory or directory to file");
        }
        if (aFromFile.isDirectory()) {
            if (!aToFile.exists() && !aToFile.mkdirs()) {
                throw new RuntimeException("Unable to create new directory: " + aToFile.getAbsolutePath());
            }
            for (File file : aFromFile.listFiles()) {
                FileUtils.copy(file, new File(aToFile, file.getName()));
            }
        } else {
            FileUtils.copyFile(aFromFile, aToFile);
        }
    }

    public static String sizeFromBytes(long aByteCount) {
        return FileUtils.sizeFromBytes(aByteCount, false);
    }

    public static String sizeFromBytes(long aByteCount, boolean aAbbreviatedLabel) {
        long count = aByteCount / 0x40000000L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " GB" : " gigabytes");
        }
        count = aByteCount / 0x100000L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " MB" : " megabytes");
        }
        count = aByteCount / 1024L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " KB" : " kilobytes");
        }
        return count + (aAbbreviatedLabel ? " B" : " bytes");
    }

    public static String hash(File aFile, String aAlgorithm) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(aAlgorithm);
        FileInputStream inStream = new FileInputStream(aFile);
        DigestInputStream mdStream = new DigestInputStream(inStream, md);
        byte[] bytes = new byte[8192];
        int bytesRead = 0;
        while (bytesRead != -1) {
            bytesRead = mdStream.read(bytes);
        }
        Formatter formatter = new Formatter();
        for (byte bite : md.digest()) {
            formatter.format("%02x", bite);
        }
        IOUtils.closeQuietly(mdStream);
        String hash = formatter.toString();
        formatter.close();
        return hash;
    }

    public static String getMimeType(String aFileUrl) throws IOException {
        return URLConnection.getFileNameMap().getContentTypeFor(aFileUrl);
    }

    public static boolean dirIsUseable(String aDirName, String aPermString) {
        File dir = new File(aDirName);
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        if (aPermString.contains("r") && !dir.canRead()) {
            return false;
        }
        if (aPermString.contains("w") && !dir.canWrite()) {
            return false;
        }
        return !aPermString.contains("x") || dir.canExecute();
    }

    public static Set<PosixFilePermission> convertToPermissionsSet(int aMode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if (FileUtils.isSet(aMode, 256)) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (FileUtils.isSet(aMode, 128)) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (FileUtils.isSet(aMode, 64)) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (FileUtils.isSet(aMode, 32)) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (FileUtils.isSet(aMode, 16)) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (FileUtils.isSet(aMode, 8)) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (FileUtils.isSet(aMode, 4)) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (FileUtils.isSet(aMode, 2)) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (FileUtils.isSet(aMode, 1)) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static int convertToInt(Set<PosixFilePermission> aPermSet) {
        int result = 0;
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x100;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0x80;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x40;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x20;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x10;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 8;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    private static boolean isSet(int mode, int testbit) {
        return (mode & testbit) == testbit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean copyFile(File aSourceFile, File aDestFile) throws IOException {
        FileOutputStream outputStream = null;
        FileInputStream inputStream = null;
        boolean success = true;
        if (aDestFile.exists() && !aDestFile.delete()) {
            success = false;
        }
        if (success && !aDestFile.createNewFile()) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Failed to create: " + aDestFile.getAbsolutePath());
            }
            success = false;
        }
        if (success) {
            try {
                outputStream = new FileOutputStream(aDestFile);
                inputStream = new FileInputStream(aSourceFile);
                FileChannel source = inputStream.getChannel();
                outputStream.getChannel().transferFrom(source, 0L, source.size());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(outputStream);
            IOUtils.closeQuietly(inputStream);
        }
        if (success && aDestFile.exists() && aSourceFile.canRead()) {
            success = aDestFile.setReadable(true, true);
        }
        if (success && aDestFile.exists() && aSourceFile.canWrite()) {
            success = aDestFile.setWritable(true, true);
        }
        if (success && aDestFile.exists() && aSourceFile.canExecute()) {
            success = aDestFile.setExecutable(true, true);
        }
        if (!success && !aDestFile.delete() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Unable to delete: " + aDestFile.getAbsolutePath());
        }
        return success;
    }

    private static Element add(File aFile, Element aParent, RegexFileFilter aFilter, boolean aDeepAdd) throws FileNotFoundException {
        Element element;
        String tagName = aFile.isDirectory() ? DIR_TYPE : FILE_TYPE;
        if (aParent == null) {
            try {
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                Object[] doc = f.newDocumentBuilder().newDocument();
                element = doc.createElement(tagName);
            }
            catch (ParserConfigurationException details) {
                throw new RuntimeException(details);
            }
        } else {
            element = aParent.getOwnerDocument().createElement(tagName);
            aParent.appendChild(element);
        }
        FileUtils.copyMetadata(aFile, element);
        if (aFile.isDirectory()) {
            if (aDeepAdd) {
                Object[] dirs = FileUtils.listFiles(aFile, new RegexDirFilter(".*"));
                Arrays.sort(dirs);
                for (Object dir : dirs) {
                    element.appendChild(FileUtils.add((File)dir, element, aFilter, aDeepAdd));
                }
            } else if (aFilter.toString().equals(".*")) {
                Document doc = element.getOwnerDocument();
                Object[] dirs = FileUtils.listFiles(aFile, new RegexDirFilter(".*"));
                Arrays.sort(dirs);
                Object[] objectArray = dirs;
                int n = objectArray.length;
                for (int dir = 0; dir < n; ++dir) {
                    Object dir2 = objectArray[dir];
                    Element dirElem = doc.createElement(DIR_TYPE);
                    element.appendChild(dirElem);
                    FileUtils.copyMetadata((File)dir2, dirElem);
                }
            }
            Object[] files = FileUtils.listFiles(aFile, aFilter);
            Arrays.sort(files);
            for (Object file : files) {
                element.appendChild(FileUtils.add((File)file, element, aFilter, aDeepAdd));
            }
        }
        return element;
    }

    private static void copyMetadata(File aFile, Element aElement) {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        StringBuilder permissions = new StringBuilder();
        Date date = new Date(aFile.lastModified());
        aElement.setAttribute(FILE_PATH, aFile.getAbsolutePath());
        aElement.setAttribute(MODIFIED, formatter.format(date));
        if (aFile.canRead()) {
            permissions.append('r');
        }
        if (aFile.canWrite()) {
            permissions.append('w');
        }
        aElement.setAttribute("permissions", permissions.toString());
    }
}

