/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.StringUtils;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.io.File;
import java.util.ResourceBundle;

public abstract class I18nObject {
    private final XMLResourceBundle BUNDLE;

    I18nObject() {
        this.BUNDLE = null;
    }

    public I18nObject(String aBundleName) {
        this.BUNDLE = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName.toLowerCase(), new XMLBundleControl());
    }

    protected String getI18n(String aMessageKey) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey));
    }

    protected String getI18n(String aMessageKey, long aLongDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, Long.toString(aLongDetail)));
    }

    protected String getI18n(String aMessageKey, int aIntDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, Integer.toString(aIntDetail)));
    }

    protected String getI18n(String aMessageKey, String aDetail) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, aDetail));
    }

    protected String getI18n(String aMessageKey, String ... aDetailsArray) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, aDetailsArray));
    }

    protected String getI18n(String aMessageKey, Exception aException) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, aException.getMessage()));
    }

    protected String getI18n(String aMessageKey, File aFile) {
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, aFile.getAbsolutePath()));
    }

    protected String getI18n(String aMessageKey, File ... aFileArray) {
        String[] fileNames = new String[aFileArray.length];
        for (int index = 0; index < fileNames.length; ++index) {
            fileNames[index] = aFileArray[index].getAbsolutePath();
        }
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, fileNames));
    }

    protected String getI18n(String aMessageKey, Object ... aObjArray) {
        String[] strings = new String[aObjArray.length];
        for (int index = 0; index < aObjArray.length; ++index) {
            strings[index] = aObjArray[index] instanceof File ? ((File)aObjArray[index]).getAbsolutePath() : aObjArray[index].toString();
        }
        return StringUtils.normalizeWS(this.BUNDLE.get(aMessageKey, strings));
    }

    protected boolean hasI18nKey(String aMessageKey) {
        return this.BUNDLE != null && this.BUNDLE.containsKey(aMessageKey);
    }
}

