/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class I18nRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1137212882896281357L;
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nRuntimeException.class);

    public I18nRuntimeException() {
    }

    public I18nRuntimeException(String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, new String[0]));
    }

    public I18nRuntimeException(Locale aLocale, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, new Object[0]));
    }

    public I18nRuntimeException(String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, aVarargs));
    }

    public I18nRuntimeException(Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, aVarargs));
    }

    public I18nRuntimeException(Throwable aCause) {
        super(aCause);
    }

    public I18nRuntimeException(Throwable aCause, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, new Object[0]), aCause);
    }

    public I18nRuntimeException(Throwable aCause, Locale aLocale, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, new Object[0]), aCause);
    }

    public I18nRuntimeException(Throwable aCause, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, aVarargs), aCause);
    }

    public I18nRuntimeException(Throwable aCause, Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, aVarargs), aCause);
    }

    private static String format(String aBundleName, String aMessageKey, Object ... aVarargs) {
        return I18nRuntimeException.format(null, aBundleName, aMessageKey, aVarargs);
    }

    private static String format(Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        XMLResourceBundle bundle;
        if (aBundleName == null) {
            throw new NullPointerException("Exception ResourceBundle name may not be null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Constructing exception message using bundle name: {}", (Object)aBundleName);
        }
        if (aMessageKey == null) {
            throw new NullPointerException("Exception message key may not be null");
        }
        if (aLocale != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Constructing exception message using supplied locale: {}", (Object)aLocale.toString());
            }
            bundle = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName, aLocale, new XMLBundleControl());
        } else {
            bundle = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName, new XMLBundleControl());
        }
        if (aVarargs != null && aVarargs.length > 0) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Formatting exception message for '{}' using: {} [{}]", aMessageKey, aVarargs, aVarargs.getClass().getSimpleName());
            }
            return bundle.get(aMessageKey, aVarargs);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Formatting exception message for '{}'", (Object)aMessageKey);
        }
        return bundle.get(aMessageKey);
    }
}

