/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.JarUtils;
import info.freelibrary.util.XMLBundleControl;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JarClassLoader
extends URLClassLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarClassLoader.class);
    private static final ResourceBundle RB = ResourceBundle.getBundle("freelib-utils_messages", new XMLBundleControl());

    public JarClassLoader(String aMainClassName) throws Exception {
        super(JarUtils.getJarURLs());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(RB.getString("UTIL_MESSAGE-001"), (Object)aMainClassName);
        }
        this.loadClass(aMainClassName).newInstance();
    }

    public JarClassLoader(URL[] aURLs, String aMainClassName) throws Exception {
        super(aURLs);
        this.loadClass(aMainClassName).newInstance();
    }

    public JarClassLoader(List<URL> aListOfURLs, String aMainClassName) throws Exception {
        super(aListOfURLs.toArray(new URL[aListOfURLs.size()]));
        this.loadClass(aMainClassName).newInstance();
    }

    @Override
    public Class<?> loadClass(String aName) throws ClassNotFoundException {
        Class<?> loadedClass = this.findLoadedClass(aName);
        if (loadedClass == null) {
            try {
                loadedClass = this.findClass(aName);
            }
            catch (ClassNotFoundException details) {
                LOGGER.trace("Class for {} not found... trying super class", (Object)aName, (Object)details);
                loadedClass = super.loadClass(aName);
            }
        }
        return loadedClass;
    }
}

