/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.ClasspathUtils;
import info.freelibrary.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarUtils {
    private static final String JAR_URL_PROTOCOL = "jar:file://";

    private JarUtils() {
    }

    public static URL[] getJarURLs() throws IOException {
        LinkedList<URL> urlList = new LinkedList<URL>();
        for (JarFile jarFile : ClasspathUtils.getJarFiles()) {
            String classpath;
            Attributes attributes;
            Manifest manifest = jarFile.getManifest();
            URL jarURL = new URL(JAR_URL_PROTOCOL + jarFile.getName() + "!/");
            urlList.add(jarURL);
            if (manifest != null && (attributes = manifest.getMainAttributes()) != null && (classpath = attributes.getValue("Class-Path")) != null) {
                StringTokenizer tokenizer = new StringTokenizer(classpath);
                while (tokenizer.hasMoreTokens()) {
                    String jarPath = tokenizer.nextToken();
                    if (!jarPath.endsWith(".jar")) continue;
                    urlList.add(new URL(jarURL.toExternalForm() + jarPath));
                }
            }
            jarFile.close();
        }
        return urlList.toArray(new URL[urlList.size()]);
    }

    public static final void extract(String aJarFilePath, String aFilePath, File aDestDir) throws IOException {
        File file;
        try {
            JarURLConnection connection = (JarURLConnection)new URL(aJarFilePath).openConnection();
            file = new File(connection.getJarFileURL().getFile());
        }
        catch (MalformedURLException details) {
            file = new File(aJarFilePath);
        }
        JarUtils.extract(file, aFilePath, aDestDir);
    }

    public static final void extract(File aJarFile, String aFilePath, File aDestDir) throws IOException {
        JarUtils.extract(new JarFile(aJarFile), aFilePath, aDestDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void extract(JarFile aJarFile, String aFilePath, File aDestDir) throws IOException {
        Enumeration<JarEntry> entries = aJarFile.entries();
        try {
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                File file = new File(aDestDir + File.separator + entryName);
                if (!entryName.equals(aFilePath)) continue;
                File parent = file.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException("Unable to create directory structure for: " + file);
                }
                InputStream inputStream = aJarFile.getInputStream(entry);
                FileOutputStream outputStream = new FileOutputStream(file);
                IOUtils.copyStream(inputStream, (OutputStream)outputStream);
                IOUtils.closeQuietly(inputStream);
                IOUtils.closeQuietly(outputStream);
            }
        }
        finally {
            aJarFile.close();
        }
    }
}

