/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.ClasspathUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class NativeLibraryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibraryLoader.class, "freelib-utils_messages");
    private static Architecture myArchitecture = Architecture.UNKNOWN;

    private NativeLibraryLoader() {
    }

    public static void load(String aNativeLibrary) throws IOException {
        String libFileName = NativeLibraryLoader.getPlatformLibraryName(aNativeLibrary);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File libFile = new File(tmpDir, libFileName);
        if (!libFile.exists() || libFile.length() == 0L) {
            URL url = ClasspathUtils.findFirst(libFileName);
            if (url == null) {
                throw new FileNotFoundException(LOGGER.getMessage("UTIL_MESSAGE-002", aNativeLibrary));
            }
            JarFile jarFile = new JarFile(url.getFile());
            JarEntry jarEntry = jarFile.getJarEntry(libFileName);
            InputStream inStream = jarFile.getInputStream(jarEntry);
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(libFile));
            IOUtils.copyStream(inStream, (OutputStream)outStream);
            IOUtils.closeQuietly(inStream);
            IOUtils.closeQuietly(outStream);
            IOUtils.closeQuietly(jarFile);
        }
        if (!libFile.exists() || libFile.length() <= 0L) {
            throw new IOException("Problem creating libfile");
        }
        System.load(libFile.getAbsolutePath());
    }

    public static Architecture getArchitecture() {
        Processor processor;
        if (Architecture.UNKNOWN == myArchitecture && Processor.UNKNOWN != (processor = NativeLibraryLoader.getProcessor())) {
            String name = System.getProperty("os.name").toLowerCase();
            if (name.indexOf("nix") >= 0 || name.indexOf("nux") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.LINUX_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.LINUX_64;
                } else if (Processor.ARM == processor) {
                    myArchitecture = Architecture.LINUX_ARM;
                }
            } else if (name.indexOf("win") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.WINDOWS_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.WINDOWS_64;
                }
            } else if (name.indexOf("mac") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.OSX_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.OSX_64;
                } else if (Processor.PPC == processor) {
                    myArchitecture = Architecture.OSX_PPC;
                }
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Architecture is {} and os.name is {}", (Object)myArchitecture, (Object)System.getProperty("os.name").toLowerCase());
        }
        return myArchitecture;
    }

    private static Processor getProcessor() {
        Processor processor = Processor.UNKNOWN;
        String arch = System.getProperty("os.arch").toLowerCase();
        if (arch.indexOf("arm") >= 0) {
            processor = Processor.ARM;
        } else if (arch.indexOf("ppc") >= 0) {
            processor = Processor.PPC;
        } else if (arch.indexOf("86") >= 0 || arch.indexOf("amd") >= 0) {
            int bits = 32;
            if (arch.indexOf("64") >= 0) {
                bits = 64;
            }
            Processor processor2 = processor = 32 == bits ? Processor.INTEL_32 : Processor.INTEL_64;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Processor is {} and os.arch is {}", (Object)processor, (Object)System.getProperty("os.arch").toLowerCase());
        }
        return processor;
    }

    public static String getPlatformLibraryName(String aLibraryName) {
        String libName = null;
        switch (NativeLibraryLoader.getArchitecture()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM: {
                libName = "lib" + aLibraryName + ".so";
                break;
            }
            case WINDOWS_32: 
            case WINDOWS_64: {
                libName = aLibraryName + ".dll";
                break;
            }
            case OSX_32: 
            case OSX_64: {
                libName = "lib" + aLibraryName + ".dylib";
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Requested library name {}", (Object)libName);
        }
        return libName;
    }

    private static enum Processor {
        UNKNOWN,
        INTEL_32,
        INTEL_64,
        PPC,
        ARM;

    }

    public static enum Architecture {
        UNKNOWN,
        LINUX_32,
        LINUX_64,
        LINUX_ARM,
        WINDOWS_32,
        WINDOWS_64,
        OSX_32,
        OSX_64,
        OSX_PPC;

    }
}

