/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.FileUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.PairtreeObject;
import info.freelibrary.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class PairtreeRoot
extends File {
    public static final String PT_VERSION_NUM = "0.1";
    private static final long serialVersionUID = 148951612898582350L;
    private static final String PAIRTREE_PREFIX = "pairtree_prefix";
    private static final String PAIRTREE_ROOT = "pairtree_root";
    private static final String PAIRTREE_VERSION = "pairtree_version";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final Logger LOGGER = LoggerFactory.getLogger(PairtreeRoot.class, "freelib-utils_messages");
    private String myPairtreePrefix;

    public PairtreeRoot(String aParentDirPath) throws IOException {
        this(new File(aParentDirPath));
    }

    public PairtreeRoot(String aParentDirPath, String aPairtreePrefix) throws IOException {
        this(new File(aParentDirPath), aPairtreePrefix);
    }

    public PairtreeRoot(File aParentDir) throws IOException {
        this(aParentDir, null);
    }

    public PairtreeRoot(File aParentDir, String aPairtreePrefix) throws IOException {
        super(aParentDir, PAIRTREE_ROOT);
        if (aPairtreePrefix != null) {
            File prefixFile = new File(aParentDir, PAIRTREE_PREFIX);
            this.myPairtreePrefix = aPairtreePrefix;
            this.writePrefixFile(prefixFile, this.getPairtreePrefix());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PT-MESSAGE-001", (Object)aParentDir);
            if (aPairtreePrefix != null) {
                LOGGER.debug("PT-MESSAGE-003", (Object)this.myPairtreePrefix);
            }
        }
        if (this.exists() && !this.canRead()) {
            throw new IOException(LOGGER.getMessage("PT-MESSAGE-009", this));
        }
        if (!this.exists() && !this.mkdirs()) {
            throw new IOException(LOGGER.getMessage("PT-MESSAGE-002", this));
        }
        this.writeVersionFile(new File(aParentDir, this.getVersionFileName()));
    }

    public PairtreeObject getObject(String aName) {
        return this.myPairtreePrefix == null ? new PairtreeObject(this, aName) : new PairtreeObject(this, this.myPairtreePrefix, aName);
    }

    @Override
    public boolean delete() {
        File prefixFile = new File(this.getParentFile(), PAIRTREE_PREFIX);
        File ptVersion = new File(this.getParentFile(), this.getVersionFileName());
        boolean result = true;
        if (prefixFile.exists() && !prefixFile.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree prefix file");
            }
            result = false;
        }
        if (ptVersion.exists() && !ptVersion.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree version file");
            }
            result = false;
        }
        for (File file : this.listFiles()) {
            if (FileUtils.delete(file)) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete " + file);
            }
            result = false;
        }
        if (!super.delete()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Unable to delete pairtree directory");
            }
            result = false;
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.myPairtreePrefix == null ? 0 : this.myPairtreePrefix.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        if (this.getClass() != aObject.getClass()) {
            return false;
        }
        PairtreeRoot other = (PairtreeRoot)aObject;
        return !(this.myPairtreePrefix == null ? other.myPairtreePrefix != null : !this.myPairtreePrefix.equals(other.myPairtreePrefix));
    }

    public String getPairtreePrefix() {
        return this.myPairtreePrefix;
    }

    public String getVersionFileName() {
        return PAIRTREE_VERSION + PT_VERSION_NUM.replace('.', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeVersionFile(File aFile) throws IOException {
        if (!aFile.exists()) {
            BufferedWriter writer = null;
            try {
                FileOutputStream fileOut = new FileOutputStream(aFile);
                CharsetEncoder encoder = Charset.forName(DEFAULT_CHARSET).newEncoder();
                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, encoder));
                writer.write(LOGGER.getMessage("PT-MESSAGE-007", PT_VERSION_NUM));
                writer.newLine();
                writer.write(LOGGER.getMessage("PT-MESSAGE-008", new Object[0]));
                writer.newLine();
                writer.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePrefixFile(File aFile, String aPtPrefix) throws IOException {
        block4: {
            block3: {
                if (aFile.exists()) break block3;
                BufferedWriter writer = null;
                try {
                    FileOutputStream fileOut = new FileOutputStream(aFile);
                    CharsetEncoder encoder = Charset.forName(DEFAULT_CHARSET).newEncoder();
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOut, encoder));
                    writer.write(aPtPrefix);
                    writer.newLine();
                    writer.close();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
                IOUtils.closeQuietly(writer);
                break block4;
            }
            String prefix = StringUtils.read(aFile, DEFAULT_CHARSET);
            if (!prefix.equals(aPtPrefix)) {
                throw new IOException(LOGGER.getMessage("PT-MESSAGE-006", prefix, aPtPrefix));
            }
        }
    }
}

