/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.InvalidPtPathException;
import info.freelibrary.util.PairtreeRoot;
import info.freelibrary.util.StringUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class PairtreeUtils {
    public static final String HEX_INDICATOR = "^";
    private static Character mySeparator = Character.valueOf(File.separatorChar);
    private static int myShortyLength = 2;

    private PairtreeUtils() {
    }

    public static int getShortyLength() {
        return myShortyLength;
    }

    public static void setShortyLength(int aLength) {
        myShortyLength = aLength;
    }

    public static Character getSeparator() {
        return mySeparator;
    }

    public static void setSeparator(Character aSeparator) {
        mySeparator = aSeparator;
    }

    public static String mapToPtPath(String aID) {
        if (aID == null) {
            throw new NullPointerException("Pairtree ID may not be null");
        }
        String encodedID = PairtreeUtils.encodeID(aID);
        ArrayList<String> shorties = new ArrayList<String>();
        int start = 0;
        while (start < encodedID.length()) {
            int end = start + myShortyLength;
            if (end > encodedID.length()) {
                end = encodedID.length();
            }
            shorties.add(encodedID.substring(start, end));
            start = end;
        }
        return PairtreeUtils.concat(shorties.toArray(new String[shorties.size()]));
    }

    public static String mapToPtPath(String aBasePath, String aID) {
        return PairtreeUtils.concat(aBasePath, PairtreeUtils.mapToPtPath(aID), null);
    }

    public static String mapToPtPath(String aBasePath, String aID, String aEncapsulatingDirName) {
        if (aID == null) {
            throw new NullPointerException("Pairtree path ID may not be null");
        }
        if (aEncapsulatingDirName == null) {
            return PairtreeUtils.concat(aBasePath, PairtreeUtils.mapToPtPath(aID));
        }
        return PairtreeUtils.concat(aBasePath, PairtreeUtils.mapToPtPath(aID), PairtreeUtils.encodeID(aEncapsulatingDirName));
    }

    public static String mapToID(String aBasePath, String aPtPath) throws InvalidPtPathException {
        String newPath = PairtreeUtils.removeBasePath(aBasePath, aPtPath);
        return PairtreeUtils.mapToID(newPath);
    }

    public static String mapToID(String aPtPath) throws InvalidPtPathException {
        String encapsulatingDir;
        String id = aPtPath;
        if (id.endsWith(Character.toString(mySeparator.charValue()))) {
            id = id.substring(0, id.length() - 1);
        }
        if ((encapsulatingDir = PairtreeUtils.getEncapsulatingDir(aPtPath)) != null) {
            id = id.substring(0, id.length() - encapsulatingDir.length());
        }
        id = id.replace(Character.toString(mySeparator.charValue()), "");
        id = PairtreeUtils.decodeID(id);
        return id;
    }

    public static String getEncapsulatingDir(String aBasePath, String aPtPath) throws InvalidPtPathException {
        String newPath = PairtreeUtils.removeBasePath(aBasePath, aPtPath);
        return PairtreeUtils.getEncapsulatingDir(newPath);
    }

    public static String getEncapsulatingDir(String aPtPath) throws InvalidPtPathException {
        if (aPtPath == null) {
            throw new NullPointerException("Pairtree path may not be null");
        }
        String[] pPathParts = aPtPath.split("\\" + mySeparator);
        if (pPathParts.length == 1) {
            if (pPathParts[0].length() <= myShortyLength) {
                return null;
            }
            throw new InvalidPtPathException(StringUtils.format("PtPath {} contains no shorties", aPtPath));
        }
        for (int i = 0; i < pPathParts.length - 2; ++i) {
            if (pPathParts[i].length() == myShortyLength) continue;
            throw new InvalidPtPathException(StringUtils.format("PtPath {} parts count should be {} but is {}", aPtPath, myShortyLength, pPathParts[i].length()));
        }
        String nextToLastPart = pPathParts[pPathParts.length - 2];
        String lastPart = pPathParts[pPathParts.length - 1];
        if (nextToLastPart.length() > myShortyLength) {
            throw new InvalidPtPathException(StringUtils.format("Pairtree Path {} has parts of incorrect length", aPtPath));
        }
        if (nextToLastPart.length() == myShortyLength) {
            if (lastPart.length() > myShortyLength) {
                return PairtreeUtils.decodeID(lastPart);
            }
            return null;
        }
        return PairtreeUtils.decodeID(lastPart);
    }

    private static String concat(String ... aPathsVarargs) {
        if (aPathsVarargs == null || aPathsVarargs.length == 0) {
            return null;
        }
        StringBuffer pathBuf = new StringBuffer();
        Character lastChar = null;
        for (int i = 0; i < aPathsVarargs.length; ++i) {
            if (aPathsVarargs[i] == null) continue;
            if (lastChar != null && !mySeparator.equals(lastChar)) {
                pathBuf.append(mySeparator);
            }
            pathBuf.append(aPathsVarargs[i]);
            int length = aPathsVarargs[i].length();
            lastChar = Character.valueOf(aPathsVarargs[i].charAt(length - 1));
        }
        return pathBuf.toString();
    }

    public static String removePrefix(String aPrefix, String aID) {
        if (aPrefix == null) {
            throw new NullPointerException("Pairtree prefix may not be null");
        }
        if (aID == null) {
            throw new NullPointerException("Pairtree ID may not be null");
        }
        if (aID.indexOf(aPrefix) == 0) {
            return aID.substring(aPrefix.length());
        }
        return aID;
    }

    public static String removeBasePath(String aBasePath, String aPtPath) {
        if (aBasePath == null) {
            throw new NullPointerException("Base path may not be null");
        }
        if (aPtPath == null) {
            throw new NullPointerException("Pairtree path may not be null");
        }
        String newPath = aPtPath;
        if (aPtPath.startsWith(aBasePath) && (newPath = newPath.substring(aBasePath.length())).startsWith(Character.toString(mySeparator.charValue()))) {
            newPath = newPath.substring(1);
        }
        return newPath;
    }

    public static String encodeID(String aID) {
        int c;
        byte[] bytes;
        if (aID == null) {
            throw new NullPointerException("Pairtree ID may not be null");
        }
        try {
            bytes = aID.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException details) {
            throw new RuntimeException("Error getting UTF-8 for path", details);
        }
        StringBuffer idBuf = new StringBuffer();
        for (c = 0; c < bytes.length; ++c) {
            byte b = bytes[c];
            int i = b & 0xFF;
            if (i < 33 || i > 126 || i == 34 || i == 42 || i == 43 || i == 44 || i == 60 || i == 61 || i == 62 || i == 63 || i == 92 || i == 94 || i == 124) {
                idBuf.append(HEX_INDICATOR);
                idBuf.append(Integer.toHexString(i));
                continue;
            }
            char[] chars = Character.toChars(i);
            assert (chars.length == 1);
            idBuf.append(chars[0]);
        }
        for (c = 0; c < idBuf.length(); ++c) {
            char ch = idBuf.charAt(c);
            if (ch == '/') {
                idBuf.setCharAt(c, '=');
                continue;
            }
            if (ch == ':') {
                idBuf.setCharAt(c, '+');
                continue;
            }
            if (ch != '.') continue;
            idBuf.setCharAt(c, ',');
        }
        return idBuf.toString();
    }

    public static String decodeID(String aID) {
        StringBuffer idBuf = new StringBuffer();
        for (int c = 0; c < aID.length(); ++c) {
            char ch = aID.charAt(c);
            if (ch == '=') {
                idBuf.append('/');
                continue;
            }
            if (ch == '+') {
                idBuf.append(':');
                continue;
            }
            if (ch == ',') {
                idBuf.append('.');
                continue;
            }
            if (ch == '^') {
                String hex = aID.substring(c + 1, c + 3);
                char[] chars = Character.toChars(Integer.parseInt(hex, 16));
                assert (chars.length == 1);
                idBuf.append(chars[0]);
                c += 2;
                continue;
            }
            idBuf.append(ch);
        }
        return idBuf.toString();
    }

    public boolean pathExists(PairtreeRoot aRoot, String aID) {
        String id = PairtreeUtils.removePrefix(aRoot.getPairtreePrefix(), aID);
        return new File(aRoot, PairtreeUtils.mapToPtPath(null, id, id)).exists();
    }

    public boolean objExists(PairtreeRoot aRoot, String aID) {
        String id = PairtreeUtils.removePrefix(aRoot.getPairtreePrefix(), aID);
        return new File(aRoot, PairtreeUtils.mapToPtPath("", aID, aID)).exists();
    }
}

