/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import net.iharder.Base64;

public final class PasswordUtils {
    private PasswordUtils() {
    }

    public static String generateSalt() {
        return new BigInteger(40, new SecureRandom()).toString(32);
    }

    public static String encrypt(String aText) throws IOException {
        return PasswordUtils.encrypt(aText, "");
    }

    public static String encrypt(String aText, String aSalt) throws NullPointerException, IOException {
        if (aText == null) {
            throw new NullPointerException("Text to encrypt is null");
        }
        if (aSalt == null) {
            throw new NullPointerException("Salt to encrypt with is null");
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            String saltedText = aText + aSalt;
            digest.update(saltedText.getBytes("UTF-8"));
            return Base64.encodeBytes((byte[])digest.digest());
        }
        catch (NoSuchAlgorithmException details) {
            throw new RuntimeException(details);
        }
        catch (UnsupportedEncodingException details) {
            throw new RuntimeException(details);
        }
    }
}

