/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLResourceBundle
extends ResourceBundle {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLResourceBundle.class);
    private final Properties myProperties = new Properties();

    XMLResourceBundle(InputStream aInStream) throws IOException {
        this.myProperties.loadFromXML(aInStream);
    }

    @Override
    protected Object handleGetObject(String aKey) {
        return this.myProperties.getProperty(aKey);
    }

    @Override
    public Enumeration<String> getKeys() {
        final Enumeration<Object> enumeration = this.myProperties.elements();
        return new Enumeration<String>(){

            @Override
            public boolean hasMoreElements() {
                return enumeration.hasMoreElements();
            }

            @Override
            public String nextElement() {
                return (String)enumeration.nextElement();
            }
        };
    }

    public String get(String aMessage, String ... aArray) {
        return StringUtils.format(super.getString(aMessage), aArray);
    }

    public String get(String aMessage, String aDetail) {
        return StringUtils.format(super.getString(aMessage), aDetail);
    }

    public String get(String aMessage) {
        return this.getString(aMessage);
    }

    public String get(String aMessage, File ... aFileArray) {
        String[] strings = new String[aFileArray.length];
        for (int index = 0; index < strings.length; ++index) {
            strings[index] = aFileArray[index].getAbsolutePath();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Formatting '{}' with: {}", (Object)aMessage, (Object)strings);
        }
        return StringUtils.format(super.getString(aMessage), strings);
    }

    public String get(String aMessage, File aFile) {
        return StringUtils.format(super.getString(aMessage), aFile.getAbsolutePath());
    }

    public String get(File aFile) {
        return this.getString(aFile.getAbsolutePath());
    }

    public String get(String aMessage, Object ... aDetailsArray) {
        String[] strings = new String[aDetailsArray.length];
        for (int index = 0; index < strings.length; ++index) {
            strings[index] = aDetailsArray[index].toString();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Formatting '{}' with: {}", (Object)aMessage, (Object)strings);
        }
        return StringUtils.format(super.getString(aMessage), strings);
    }

    public String get(String aMessage, Object aDetail) {
        return StringUtils.format(super.getString(aMessage), aDetail.toString());
    }

    public String get(Object aObject) {
        return this.getString(aObject.toString());
    }

    @Override
    public boolean containsKey(String aKey) {
        return this.myProperties.containsKey(aKey);
    }
}

