/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.UnsupportedEncodingI18nException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Paths;

public final class BufferedFileWriter
extends BufferedWriter {
    public BufferedFileWriter(File aFile) throws NoSuchFileException, IOException {
        super(BufferedFileWriter.getWriter(aFile));
    }

    public BufferedFileWriter(File aFile, String aEncoding) throws NoSuchFileException, IOException, UnsupportedEncodingException {
        super(new OutputStreamWriter(Files.newOutputStream(Paths.get(aFile.getAbsolutePath(), new String[0]), new OpenOption[0]), aEncoding));
    }

    private static Writer getWriter(File aFile) throws NoSuchFileException, IOException {
        try {
            return new OutputStreamWriter(Files.newOutputStream(Paths.get(aFile.getAbsolutePath(), new String[0]), new OpenOption[0]), StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException details) {
            throw new UnsupportedEncodingI18nException((Throwable)details, StandardCharsets.UTF_8);
        }
    }
}

