/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public final class ByteUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ByteUtils.class, "freelib-utils_messages");

    private ByteUtils() {
    }

    public static List<Byte> asList(byte[] aByteArray) {
        if (aByteArray.length == 0) {
            return Collections.emptyList();
        }
        return new ByteArrayAsList(aByteArray);
    }

    public static byte[] asArray(List<Byte> aByteList) {
        byte[] bytes = new byte[aByteList.size()];
        for (int index = 0; index < aByteList.size(); ++index) {
            bytes[index] = aByteList.get(index);
        }
        return bytes;
    }

    private static int indexOf(byte[] aByteArray, byte aByte, int aStart, int aEnd) {
        for (int index = aStart; index < aEnd; ++index) {
            if (aByteArray[index] != aByte) continue;
            return index;
        }
        return -1;
    }

    private static int lastIndexOf(byte[] aByteArray, byte aByte, int aStart, int aEnd) {
        for (int index = aEnd - 1; index >= aStart; --index) {
            if (aByteArray[index] != aByte) continue;
            return index;
        }
        return -1;
    }

    public static void reverse(byte[] aArray) {
        ByteUtils.reverse(aArray, 0, aArray.length - 1);
    }

    public static void reverse(byte[] aByteArray, int aStart, int aEnd) {
        Objects.requireNonNull(aByteArray);
        ByteUtils.checkPositionIndexes(aStart, aEnd, aByteArray.length);
        int index = aStart;
        for (int jndex = aEnd; index < jndex; ++index, --jndex) {
            byte tmpByte = aByteArray[index];
            aByteArray[index] = aByteArray[jndex];
            aByteArray[jndex] = tmpByte;
        }
    }

    private static void checkPositionIndexes(int aStart, int aEnd, int aSize) {
        if (aStart < 0 || aStart >= aSize) {
            throw new IndexOutOfBoundsException(LOGGER.getMessage("UTIL-070", aStart));
        }
        if (aEnd < 0 || aEnd >= aSize) {
            throw new IndexOutOfBoundsException(LOGGER.getMessage("UTIL-071", aEnd));
        }
        if (aStart > aEnd) {
            throw new IllegalArgumentException(LOGGER.getMessage("UTIL-069", aStart, aEnd));
        }
    }

    private static class ByteArrayAsList
    extends AbstractList<Byte>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 0L;
        final byte[] myArray;
        final int myStart;
        final int myEnd;

        ByteArrayAsList(byte[] aByteArray) {
            this(aByteArray, 0, aByteArray.length);
        }

        ByteArrayAsList(byte[] aByteArray, int aStart, int aEnd) {
            this.myArray = (byte[])aByteArray.clone();
            this.myStart = aStart;
            this.myEnd = aEnd;
        }

        @Override
        public int size() {
            return this.myEnd - this.myStart;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Byte get(int aIndex) {
            if (aIndex < 0 || aIndex >= this.size()) {
                throw new IndexOutOfBoundsException(aIndex);
            }
            return this.myArray[this.myStart + aIndex];
        }

        @Override
        public boolean contains(Object aObject) {
            return aObject instanceof Byte && ByteUtils.indexOf(this.myArray, (Byte)aObject, this.myStart, this.myEnd) != -1;
        }

        @Override
        public int indexOf(Object aObject) {
            int index;
            if (aObject instanceof Byte && (index = ByteUtils.indexOf(this.myArray, (Byte)aObject, this.myStart, this.myEnd)) >= 0) {
                return index - this.myStart;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object aObject) {
            int index;
            if (aObject instanceof Byte && (index = ByteUtils.lastIndexOf(this.myArray, (Byte)aObject, this.myStart, this.myEnd)) >= 0) {
                return index - this.myStart;
            }
            return -1;
        }

        @Override
        public Byte set(int aIndex, Byte aByte) {
            if (aIndex < 0 || aIndex >= this.size()) {
                throw new IndexOutOfBoundsException(aIndex);
            }
            byte oldValue = this.myArray[this.myStart + aIndex];
            this.myArray[this.myStart + aIndex] = Objects.requireNonNull(aByte);
            return oldValue;
        }

        @Override
        public List<Byte> subList(int aStart, int aEnd) {
            ByteUtils.checkPositionIndexes(aStart, aEnd, this.size());
            if (aStart == aEnd) {
                return Collections.emptyList();
            }
            return new ByteArrayAsList(this.myArray, this.myStart + aStart, this.myStart + aEnd);
        }

        @Override
        public boolean equals(Object aObject) {
            if (aObject == this) {
                return true;
            }
            if (aObject instanceof ByteArrayAsList) {
                ByteArrayAsList list = (ByteArrayAsList)aObject;
                int size = this.size();
                if (list.size() != size) {
                    return false;
                }
                for (int index = 0; index < size; ++index) {
                    if (this.myArray[this.myStart + index] == list.myArray[list.myStart + index]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(aObject);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int index = this.myStart; index < this.myEnd; ++index) {
                result = 31 * result + this.myArray[index];
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 5);
            builder.append('[').append(this.myArray[this.myStart]);
            for (int index = this.myStart + 1; index < this.myEnd; ++index) {
                builder.append(", ").append(this.myArray[index]);
            }
            return builder.append(']').toString();
        }

        byte[] toByteArray() {
            return Arrays.copyOfRange(this.myArray, this.myStart, this.myEnd);
        }
    }
}

