/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.I18nRuntimeException;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.RegexFileFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.file.attribute.PosixFilePermission;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FileUtils {
    public static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss Z";
    private static final String FILE_TYPE = "file";
    private static final String WILDCARD = ".*";
    private static final char DOT = '.';
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class, "freelib-utils_messages");

    private FileUtils() {
    }

    public static Map<String, List<String>> toHashMap(String aFilePath) throws FileNotFoundException {
        return FileUtils.toHashMap(aFilePath, null, null);
    }

    public static Map<String, List<String>> toHashMap(String aFilePath, String aPattern) throws FileNotFoundException {
        return FileUtils.toHashMap(aFilePath, aPattern, null);
    }

    public static Map<String, List<String>> toHashMap(String aFilePath, String aPattern, String ... aIgnoreList) throws FileNotFoundException {
        String filePattern = aPattern != null ? aPattern : WILDCARD;
        RegexFileFilter filter = new RegexFileFilter(filePattern);
        HashMap fileMap = new HashMap();
        File source = new File(aFilePath);
        for (File file : FileUtils.listFiles(source, filter, true, aIgnoreList)) {
            String fileName = file.getName();
            String filePath = file.getAbsolutePath();
            if (fileMap.containsKey(fileName)) {
                List paths = (List)fileMap.get(fileName);
                if (!paths.contains(filePath)) {
                    paths.add(filePath);
                    continue;
                }
                throw new I18nRuntimeException("freelib-utils_messages", "UTIL-034");
            }
            ArrayList<String> pathList = new ArrayList<String>();
            pathList.add(filePath);
            fileMap.put(fileName, pathList);
        }
        return Collections.unmodifiableMap(fileMap);
    }

    public static File toFile(URL aURL) throws MalformedURLException {
        if (aURL.getProtocol().equals(FILE_TYPE)) {
            return new File(aURL.toString().replace("file:", ""));
        }
        throw new MalformedURLException(LOGGER.getI18n("UTIL-036", aURL));
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter) throws FileNotFoundException {
        return FileUtils.listFiles(aDir, aFilter, false, null);
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter, boolean aDeepListing) throws FileNotFoundException {
        return FileUtils.listFiles(aDir, aFilter, aDeepListing, null);
    }

    public static File[] listFiles(File aDir, FilenameFilter aFilter, boolean aDeepListing, String ... aIgnoreList) throws FileNotFoundException {
        if (!aDir.exists()) {
            throw new FileNotFoundException(aDir.getAbsolutePath());
        }
        if (aDir.isFile()) {
            if (aFilter.accept(aDir.getParentFile(), aDir.getName())) {
                return new File[]{aDir};
            }
            return new File[0];
        }
        if (!aDeepListing) {
            return aDir.listFiles(aFilter);
        }
        ArrayList<File> fileList = new ArrayList<File>();
        Object[] ignoreList = aIgnoreList == null ? new String[]{} : aIgnoreList;
        for (File file : aDir.listFiles()) {
            String fileName = file.getName();
            if (aFilter.accept(aDir, fileName)) {
                LOGGER.debug("UTIL-010", (Object)file);
                fileList.add(file);
            }
            if (!file.isDirectory() || Arrays.binarySearch(ignoreList, fileName) >= 0) continue;
            LOGGER.debug("UTIL-011", (Object)file);
            File[] files = FileUtils.listFiles(file, aFilter, aDeepListing);
            fileList.addAll(Arrays.asList(files));
        }
        return fileList.toArray(new File[0]);
    }

    public static String stripExt(File aFile) {
        return FileUtils.stripExt(aFile.getName());
    }

    public static String stripExt(String aFileName) {
        int index = aFileName.lastIndexOf(46);
        if (index != -1) {
            return aFileName.substring(0, index);
        }
        return aFileName;
    }

    public static String getExt(String aFileName) {
        int index = aFileName.lastIndexOf(46);
        if (index != -1) {
            return aFileName.substring(index + 1, aFileName.length());
        }
        return "";
    }

    public static long getSize(File aFile) {
        long size = 0L;
        if (aFile != null && aFile.exists()) {
            if (aFile.isDirectory()) {
                for (File file : aFile.listFiles()) {
                    size += FileUtils.getSize(file);
                }
            } else {
                size += aFile.length();
            }
        }
        return size;
    }

    public static boolean delete(File aDir) {
        if (aDir.exists() && aDir.listFiles() != null) {
            for (File file : aDir.listFiles()) {
                if (file.isDirectory()) {
                    if (FileUtils.delete(file)) continue;
                    LOGGER.error("UTIL-012", (Object)file);
                    continue;
                }
                if (!file.exists() || file.delete()) continue;
                LOGGER.error("UTIL-012", (Object)file);
            }
        } else if (LOGGER.isDebugEnabled() && aDir.listFiles() == null) {
            LOGGER.debug("UTIL-013", (Object)aDir);
        }
        return aDir.delete();
    }

    public static void copy(File aFromFile, File aToFile) throws IOException {
        if (aFromFile.isDirectory() && aToFile.isFile() || aFromFile.isFile() && aToFile.isDirectory()) {
            throw new IOException(LOGGER.getI18n("UTIL-037", aFromFile, aToFile));
        }
        if (aFromFile.isDirectory()) {
            if (!aToFile.exists() && !aToFile.mkdirs()) {
                throw new IOException(LOGGER.getI18n("UTIL-035", aToFile.getAbsolutePath()));
            }
            for (File file : aFromFile.listFiles()) {
                FileUtils.copy(file, new File(aToFile, file.getName()));
            }
        } else {
            FileUtils.copyFile(aFromFile, aToFile);
        }
    }

    public static String sizeFromBytes(long aByteCount) {
        return FileUtils.sizeFromBytes(aByteCount, false);
    }

    public static String sizeFromBytes(long aByteCount, boolean aAbbreviatedLabel) {
        long count = aByteCount / 0x40000000L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " GB" : " gigabytes");
        }
        count = aByteCount / 0x100000L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " MB" : " megabytes");
        }
        count = aByteCount / 1024L;
        if (count > 0L) {
            return count + (aAbbreviatedLabel ? " KB" : " kilobytes");
        }
        return count + (aAbbreviatedLabel ? " B" : " bytes");
    }

    /*
     * Exception decompiling
     */
    public static String hash(File aFile, String aAlgorithm) throws NoSuchAlgorithmException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getMimeType(String aFileUrl) {
        return URLConnection.getFileNameMap().getContentTypeFor(aFileUrl);
    }

    public static boolean dirIsUseable(String aDirName, String aPermString) {
        File dir = new File(aDirName);
        if (!dir.exists() && !dir.mkdirs()) {
            return false;
        }
        if ("r".contains(aPermString)) {
            return dir.canRead();
        }
        if ("w".contains(aPermString)) {
            return dir.canWrite();
        }
        if ("x".contains(aPermString)) {
            return dir.canExecute();
        }
        return true;
    }

    public static Set<PosixFilePermission> convertToPermissionsSet(int aMode) {
        EnumSet<PosixFilePermission> result = EnumSet.noneOf(PosixFilePermission.class);
        if (FileUtils.isSet(aMode, 400)) {
            result.add(PosixFilePermission.OWNER_READ);
        }
        if (FileUtils.isSet(aMode, 200)) {
            result.add(PosixFilePermission.OWNER_WRITE);
        }
        if (FileUtils.isSet(aMode, 100)) {
            result.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (FileUtils.isSet(aMode, 40)) {
            result.add(PosixFilePermission.GROUP_READ);
        }
        if (FileUtils.isSet(aMode, 20)) {
            result.add(PosixFilePermission.GROUP_WRITE);
        }
        if (FileUtils.isSet(aMode, 10)) {
            result.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (FileUtils.isSet(aMode, 4)) {
            result.add(PosixFilePermission.OTHERS_READ);
        }
        if (FileUtils.isSet(aMode, 2)) {
            result.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (FileUtils.isSet(aMode, 1)) {
            result.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return result;
    }

    public static int convertToInt(Set<PosixFilePermission> aPermSet) {
        int result = 0;
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_READ)) {
            result |= 0x190;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            result |= 0xC8;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            result |= 0x64;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_READ)) {
            result |= 0x28;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            result |= 0x14;
        }
        if (aPermSet.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            result |= 0xA;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_READ)) {
            result |= 4;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            result |= 2;
        }
        if (aPermSet.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            result |= 1;
        }
        return result;
    }

    private static boolean isSet(int aMode, int aTestbit) {
        return (aMode & aTestbit) == aTestbit;
    }

    private static boolean copyFile(File aSourceFile, File aDestFile) throws IOException {
        boolean success = true;
        if (aDestFile.exists() && !aDestFile.delete()) {
            success = false;
        }
        if (success && !aDestFile.createNewFile()) {
            LOGGER.warn("UTIL-014", (Object)aDestFile.getAbsolutePath());
            success = false;
        }
        if (success) {
            try (FileOutputStream outputStream = new FileOutputStream(aDestFile);
                 FileInputStream inputStream = new FileInputStream(aSourceFile);
                 FileChannel source = inputStream.getChannel();){
                outputStream.getChannel().transferFrom(source, 0L, source.size());
            }
        }
        if (success && aDestFile.exists() && aSourceFile.canRead()) {
            success = aDestFile.setReadable(true, true);
        }
        if (success && aDestFile.exists() && aSourceFile.canWrite()) {
            success = aDestFile.setWritable(true, true);
        }
        if (success && aDestFile.exists() && aSourceFile.canExecute()) {
            success = aDestFile.setExecutable(true, true);
        }
        if (!success && !aDestFile.delete() && LOGGER.isWarnEnabled()) {
            LOGGER.warn("UTIL-015", (Object)aDestFile);
        }
        return success;
    }
}

