/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.ClasspathUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class JarUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarUtils.class, "freelib-utils_messages");
    private static final String JAR_URL_PROTOCOL = "jar:file://";

    private JarUtils() {
    }

    public static URL[] getJarURLs() throws IOException {
        LinkedList<URL> urlList = new LinkedList<URL>();
        JarFile[] jarFileArray = ClasspathUtils.getJarFiles();
        int n = jarFileArray.length;
        for (int i = 0; i < n; ++i) {
            JarFile jarFile;
            try (JarFile jarFile2 = jarFile = jarFileArray[i];){
                String classpath;
                Attributes attributes;
                Manifest manifest = jarFile.getManifest();
                URL jarURL = new URL(JAR_URL_PROTOCOL + jarFile.getName() + "!/");
                urlList.add(jarURL);
                if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (classpath = attributes.getValue("Class-Path")) == null) continue;
                StringTokenizer tokenizer = new StringTokenizer(classpath);
                while (tokenizer.hasMoreTokens()) {
                    String jarPath = tokenizer.nextToken();
                    if (!jarPath.endsWith(".jar")) continue;
                    urlList.add(new URL(jarURL.toExternalForm() + jarPath));
                }
                continue;
            }
        }
        return urlList.toArray(new URL[0]);
    }

    public static void extract(String aJarFilePath, String aFilePath, File aDestDir) throws IOException {
        File file;
        try {
            JarURLConnection connection = (JarURLConnection)new URL(aJarFilePath).openConnection();
            file = new File(connection.getJarFileURL().getFile());
        }
        catch (MalformedURLException details) {
            file = new File(aJarFilePath);
        }
        JarUtils.extract(file, aFilePath, aDestDir);
    }

    public static void extract(File aJarFile, String aFilePath, File aDestDir) throws IOException {
        JarUtils.extract(new JarFile(aJarFile), aFilePath, aDestDir);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void extract(JarFile aJarFile, String aFilePath, File aDestDir) throws IOException {
        Enumeration<JarEntry> entries = aJarFile.entries();
        try (JarFile jarFile = aJarFile;){
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                File file = new File(aDestDir + File.separator + entryName);
                if (!entryName.equals(aFilePath)) continue;
                File parent = file.getParentFile();
                if (!parent.exists() && !parent.mkdirs()) {
                    throw new IOException(LOGGER.getI18n("UTIL-038", file));
                }
                InputStream inputStream = aJarFile.getInputStream(entry);
                try {
                    OutputStream outputStream = Files.newOutputStream(Paths.get(file.getAbsolutePath(), new String[0]), new OpenOption[0]);
                    try {
                        IOUtils.copyStream(inputStream, outputStream);
                    }
                    finally {
                        if (outputStream == null) continue;
                        outputStream.close();
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            return;
        }
    }
}

