/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.ClasspathUtils;
import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.jar.JarFile;

public final class NativeLibraryLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(NativeLibraryLoader.class, "freelib-utils_messages");
    private static final String OS_NAME = "os.name";
    private static final String OS_ARCH = "os.arch";
    private static final String LIB_PREFIX = "lib";
    private static Architecture myArchitecture = Architecture.UNKNOWN;

    private NativeLibraryLoader() {
    }

    public static void load(String aNativeLibrary) throws IOException {
        String libFileName = NativeLibraryLoader.getPlatformLibraryName(aNativeLibrary);
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        File libFile = new File(tmpDir, libFileName);
        if (!libFile.exists() || libFile.length() == 0L) {
            URL url = ClasspathUtils.findFirst(libFileName);
            if (url == null) {
                throw new FileNotFoundException(LOGGER.getMessage("UTIL-002", aNativeLibrary));
            }
            try (JarFile jarFile = new JarFile(url.getFile());
                 InputStream inStream = jarFile.getInputStream(jarFile.getJarEntry(libFileName));
                 OutputStream outStream = Files.newOutputStream(Paths.get(libFile.getAbsolutePath(), new String[0]), new OpenOption[0]);){
                IOUtils.copyStream(inStream, (OutputStream)new BufferedOutputStream(outStream));
            }
        }
        if (!libFile.exists() || libFile.length() <= 0L) {
            throw new IOException(LOGGER.getI18n("UTIL-039", libFile));
        }
        System.load(libFile.getAbsolutePath());
    }

    public static Architecture getArchitecture() {
        Processor processor;
        if (Architecture.UNKNOWN == myArchitecture && Processor.UNKNOWN != (processor = NativeLibraryLoader.getProcessor())) {
            String name = System.getProperty(OS_NAME).toLowerCase(Locale.US);
            if (name.indexOf("nix") >= 0 || name.indexOf("nux") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.LINUX_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.LINUX_64;
                } else if (Processor.ARM == processor) {
                    myArchitecture = Architecture.LINUX_ARM;
                }
            } else if (name.indexOf("win") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.WINDOWS_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.WINDOWS_64;
                }
            } else if (name.indexOf("mac") >= 0) {
                if (Processor.INTEL_32 == processor) {
                    myArchitecture = Architecture.OSX_32;
                } else if (Processor.INTEL_64 == processor) {
                    myArchitecture = Architecture.OSX_64;
                } else if (Processor.PPC == processor) {
                    myArchitecture = Architecture.OSX_PPC;
                }
            }
        }
        LOGGER.debug("UTIL-023", (Object)myArchitecture, (Object)System.getProperty(OS_NAME).toLowerCase(Locale.US));
        return myArchitecture;
    }

    private static Processor getProcessor() {
        Processor processor = Processor.UNKNOWN;
        String arch = System.getProperty(OS_ARCH).toLowerCase(Locale.US);
        if (arch.indexOf("arm") >= 0) {
            processor = Processor.ARM;
        } else if (arch.indexOf("ppc") >= 0) {
            processor = Processor.PPC;
        } else if (arch.indexOf("86") >= 0 || arch.indexOf("amd") >= 0) {
            int bits = 32;
            if (arch.indexOf("64") >= 0) {
                bits = 64;
            }
            processor = 32 == bits ? Processor.INTEL_32 : Processor.INTEL_64;
        }
        LOGGER.debug("UTIL-024", (Object)processor, (Object)System.getProperty(OS_ARCH).toLowerCase(Locale.US));
        return processor;
    }

    public static String getPlatformLibraryName(String aLibraryName) {
        String libName = null;
        switch (NativeLibraryLoader.getArchitecture()) {
            case LINUX_32: 
            case LINUX_64: 
            case LINUX_ARM: {
                libName = LIB_PREFIX + aLibraryName + ".so";
                break;
            }
            case WINDOWS_32: 
            case WINDOWS_64: {
                libName = aLibraryName + ".dll";
                break;
            }
            case OSX_32: 
            case OSX_64: {
                libName = LIB_PREFIX + aLibraryName + ".dylib";
                break;
            }
            default: {
                LOGGER.warn("Unexpected architecture value: {}", (Object)NativeLibraryLoader.getArchitecture());
            }
        }
        LOGGER.debug("UTIL-025", (Object)libName);
        return libName;
    }

    private static enum Processor {
        UNKNOWN,
        INTEL_32,
        INTEL_64,
        PPC,
        ARM;

    }

    public static enum Architecture {
        UNKNOWN,
        LINUX_32,
        LINUX_64,
        LINUX_ARM,
        WINDOWS_32,
        WINDOWS_64,
        OSX_32,
        OSX_64,
        OSX_PPC;

    }
}

