/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class PortUtils {
    private PortUtils() {
    }

    public static int getPort() {
        int n;
        ServerSocket socket = new ServerSocket(0);
        try {
            n = socket.getLocalPort();
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException details) {
                throw new RuntimeException(details);
            }
        }
        socket.close();
        return n;
    }

    public static Iterator<Integer> getPortIterator() {
        return new PortIterator();
    }

    private static class PortIterator
    implements Iterator<Integer> {
        private int myNextPort;

        private PortIterator() {
        }

        @Override
        public boolean hasNext() {
            try {
                this.myNextPort = PortUtils.getPort();
                return this.myNextPort != 0;
            }
            catch (RuntimeException details) {
                return false;
            }
        }

        @Override
        public Integer next() {
            try {
                Integer port = this.myNextPort == 0 ? PortUtils.getPort() : this.myNextPort;
                this.myNextPort = 0;
                return port;
            }
            catch (RuntimeException details) {
                throw (NoSuchElementException)new NoSuchElementException(details.getMessage()).initCause(details);
            }
        }
    }
}

