/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.FileExtFileFilter;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClasspathUtils {
    private static final String CLASSPATH = "java.class.path";
    private static final String YES = "yes";
    private static final String NO = "no";
    private static final String DELIMETER = ":";
    private static final String JAR_EXT = "jar";
    private static final Logger LOGGER = LoggerFactory.getLogger(ClasspathUtils.class, "freelib-utils_messages");

    private ClasspathUtils() {
    }

    public static String[] getDirs() {
        ArrayList<String> list = new ArrayList<String>();
        for (String filename : System.getProperty(CLASSPATH).split(DELIMETER)) {
            File file;
            LOGGER.debug("UTIL-003", (Object)file, (Object)((file = new File(filename)).isDirectory() ? YES : NO));
            if (!file.isDirectory()) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[0]);
    }

    public static File[] getDirFiles() {
        ArrayList<File> list = new ArrayList<File>();
        for (String filename : System.getProperty(CLASSPATH).split(DELIMETER)) {
            File file;
            LOGGER.debug("UTIL-003", (Object)file, (Object)((file = new File(filename)).isDirectory() ? YES : NO));
            if (!file.isDirectory()) continue;
            list.add(file);
        }
        return list.toArray(new File[0]);
    }

    public static String[] getDirs(FilenameFilter aFilter) {
        ArrayList<String> list = new ArrayList<String>();
        for (String filename : System.getProperty(CLASSPATH).split(DELIMETER)) {
            File file = new File(filename);
            if (!aFilter.accept(file.getParentFile(), file.getName()) || !file.isDirectory()) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[0]);
    }

    public static File[] getDirFiles(FilenameFilter aFilter) {
        ArrayList<File> list = new ArrayList<File>();
        for (String filename : System.getProperty(CLASSPATH).split(DELIMETER)) {
            File file;
            LOGGER.debug("UTIL-003", (Object)file, (Object)((file = new File(filename)).isDirectory() ? YES : NO));
            if (!aFilter.accept(file.getParentFile(), file.getName()) || !file.isDirectory()) continue;
            LOGGER.debug("UTIL-004", (Object)file.getAbsolutePath());
            list.add(file);
        }
        return list.toArray(new File[0]);
    }

    public static String[] getJars() {
        ArrayList<String> list = new ArrayList<String>();
        FileExtFileFilter filter = new FileExtFileFilter(JAR_EXT);
        for (String part : System.getProperty(CLASSPATH).split(File.pathSeparator)) {
            File file = new File(part);
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[0]);
    }

    public static String[] getJars(FilenameFilter aFilter) {
        ArrayList<String> list = new ArrayList<String>();
        FileExtFileFilter filter = new FileExtFileFilter(JAR_EXT);
        for (String part : System.getProperty(CLASSPATH).split(File.pathSeparator)) {
            String name;
            File file = new File(part);
            File parent = file.getParentFile();
            if (!filter.accept(parent, name = file.getName()) || !aFilter.accept(parent, name)) continue;
            list.add(file.getAbsolutePath());
        }
        return list.toArray(new String[0]);
    }

    public static JarFile[] getJarFiles() throws IOException {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        FileExtFileFilter filter = new FileExtFileFilter(JAR_EXT);
        for (String part : System.getProperty(CLASSPATH).split(File.pathSeparator)) {
            File file = new File(part);
            if (!filter.accept(file.getParentFile(), file.getName())) continue;
            list.add(new JarFile(file));
        }
        return list.toArray(new JarFile[0]);
    }

    public static JarFile[] getJarFiles(FilenameFilter aFilter) throws IOException {
        ArrayList<JarFile> list = new ArrayList<JarFile>();
        FileExtFileFilter filter = new FileExtFileFilter(JAR_EXT);
        for (String part : System.getProperty(CLASSPATH).split(File.pathSeparator)) {
            String name;
            File file = new File(part);
            File parent = file.getParentFile();
            if (!filter.accept(parent, name = file.getName()) || !aFilter.accept(parent, name)) continue;
            list.add(new JarFile(file));
        }
        return list.toArray(new JarFile[0]);
    }

    public static URL findFirst(String aFileName) throws IOException {
        FileExtFileFilter filter = new FileExtFileFilter(JAR_EXT);
        for (String cpEntry : System.getProperty(CLASSPATH).split(File.pathSeparator)) {
            File file = new File(cpEntry);
            LOGGER.debug("UTIL-005", (Object)cpEntry, (Object)aFileName);
            if (file.isDirectory()) {
                File target = new File(file, aFileName);
                if (!target.exists()) continue;
                LOGGER.debug("UTIL-006", (Object)aFileName, (Object)cpEntry);
                return target.toURI().toURL();
            }
            if (filter.accept(file.getParentFile(), file.getName())) {
                try (JarFile jarFile = new JarFile(file);){
                    JarEntry jarEntry = jarFile.getJarEntry(aFileName);
                    if (jarEntry != null && jarEntry.getSize() > 0L) {
                        LOGGER.debug("UTIL-006", (Object)aFileName, (Object)cpEntry);
                        URL uRL = file.toURI().toURL();
                        return uRL;
                    }
                    if (jarEntry != null) {
                        LOGGER.debug("UTIL-007", (Object)jarEntry.getName());
                        continue;
                    }
                    LOGGER.debug("UTIL-008", (Object)aFileName);
                    continue;
                }
            }
            LOGGER.debug("UTIL-009", (Object)file);
        }
        return null;
    }

    public static boolean find(String aFileName) throws IOException {
        return ClasspathUtils.findFirst(aFileName) != null;
    }
}

