/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.StringUtils;
import info.freelibrary.util.XMLBundleControl;
import info.freelibrary.util.XMLResourceBundle;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;

public class I18nRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1137212882896281357L;
    private static final Logger LOGGER = LoggerFactory.getLogger(I18nRuntimeException.class, "freelib-utils_messages");

    public I18nRuntimeException() {
    }

    public I18nRuntimeException(String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, new String[0]));
    }

    public I18nRuntimeException(Locale aLocale, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, new Object[0]));
    }

    public I18nRuntimeException(String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, aVarargs));
    }

    public I18nRuntimeException(Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, aVarargs));
    }

    public I18nRuntimeException(Throwable aCause) {
        super(aCause);
    }

    public I18nRuntimeException(Throwable aCause, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, new Object[0]), aCause);
    }

    public I18nRuntimeException(Throwable aCause, Locale aLocale, String aBundleName, String aMessageKey) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, new Object[0]), aCause);
    }

    public I18nRuntimeException(Throwable aCause, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aBundleName, aMessageKey, aVarargs), aCause);
    }

    public I18nRuntimeException(Throwable aCause, Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        super(I18nRuntimeException.format(aLocale, aBundleName, aMessageKey, aVarargs), aCause);
    }

    private static String format(String aBundleName, String aMessageKey, Object ... aVarargs) {
        return I18nRuntimeException.format(null, aBundleName, aMessageKey, aVarargs);
    }

    private static String format(Locale aLocale, String aBundleName, String aMessageKey, Object ... aVarargs) {
        String message;
        XMLResourceBundle bundle;
        Objects.requireNonNull(aBundleName, LOGGER.getI18n("UTIL-016"));
        Objects.requireNonNull(aMessageKey, LOGGER.getI18n("UTIL-018"));
        LOGGER.debug("UTIL-022", (Object)aBundleName);
        if (aLocale != null) {
            LOGGER.debug("UTIL-019", (Object)aLocale.toString());
            bundle = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName, aLocale, new XMLBundleControl());
        } else {
            bundle = (XMLResourceBundle)ResourceBundle.getBundle(aBundleName, new XMLBundleControl());
        }
        if (aVarargs != null && aVarargs.length > 0) {
            LOGGER.debug("UTIL-020", aMessageKey, aVarargs, aVarargs.getClass().getSimpleName());
            message = bundle.containsKey(aMessageKey) ? bundle.get(aMessageKey, aVarargs) : StringUtils.format(aMessageKey, aVarargs);
        } else {
            LOGGER.debug("UTIL-021", (Object)aMessageKey);
            message = bundle.containsKey(aMessageKey) ? bundle.get(aMessageKey) : aMessageKey;
        }
        return message;
    }
}

