/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.I18nRuntimeException;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;

public final class PasswordUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PasswordUtils.class, "freelib-utils_messages");

    private PasswordUtils() {
    }

    public static String generateSalt() {
        return new BigInteger(40, new SecureRandom()).toString(32);
    }

    public static String encrypt(String aText) throws IOException {
        return PasswordUtils.encrypt(aText, "");
    }

    public static String encrypt(String aText, String aSalt) throws IOException {
        Objects.requireNonNull(aText, LOGGER.getI18n("Text to encrypt is null"));
        Objects.requireNonNull(aSalt, LOGGER.getI18n("Salt to encrypt with is null"));
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA");
            String saltedText = aText + aSalt;
            digest.update(saltedText.getBytes("UTF-8"));
            return Base64.getEncoder().encodeToString(digest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException details) {
            throw new I18nRuntimeException(details);
        }
    }
}

