/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.IOUtils;
import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.ProcessListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ProcessWatcher
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessWatcher.class, "freelib-utils_messages");
    private final List<ProcessListener> myListeners = new ArrayList<ProcessListener>();
    private final Process myProcess;

    public ProcessWatcher(ProcessBuilder aProcessBuilder) throws IOException {
        this.myProcess = aProcessBuilder.start();
    }

    @Override
    public void run() {
        try {
            this.myProcess.waitFor();
            for (ProcessListener listener : this.myListeners) {
                listener.processFinished(this.myProcess);
            }
        }
        catch (InterruptedException details) {
            LOGGER.warn(details.getMessage(), details);
        }
        finally {
            IOUtils.closeQuietly(this.myProcess.getInputStream());
            IOUtils.closeQuietly(this.myProcess.getOutputStream());
            IOUtils.closeQuietly(this.myProcess.getErrorStream());
        }
    }

    public ProcessWatcher addListener(ProcessListener aListener) {
        this.myListeners.add(aListener);
        return this;
    }

    public ProcessWatcher removeListener(ProcessListener aListener) {
        this.myListeners.remove(aListener);
        return this;
    }
}

