/*
 * Decompiled with CFR 0.152.
 */
package info.freelibrary.util;

import info.freelibrary.util.Logger;
import info.freelibrary.util.LoggerFactory;
import info.freelibrary.util.UnsupportedEncodingI18nException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.text.StringCharacterIterator;
import java.util.Locale;
import java.util.Objects;
import java.util.Scanner;

public final class URLUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLUtils.class, "freelib-utils_messages");
    private static final String FILE_PROTOCOL = "file";
    private static final String SIMPLE_PREFIX = "file:/";
    private static final String STANDARD_PREFIX = "file://";
    private static final String OS = System.getProperty("os.name");
    private static final String PERCENT = "%25";

    private URLUtils() {
    }

    public static File toFile(URL aURL) {
        Object path3;
        Objects.requireNonNull(aURL, LOGGER.getI18n("UTIL-031"));
        if (!FILE_PROTOCOL.equals(aURL.getProtocol())) {
            throw new UnsupportedOperationException(LOGGER.getI18n("UTIL-030"));
        }
        String string = aURL.toExternalForm();
        if (string.contains("+")) {
            string = string.replace("+", "%2B");
        }
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException details) {
            throw new UnsupportedEncodingI18nException((Throwable)details, "UTIL-029");
        }
        if (OS.toUpperCase(Locale.US).contains("WINDOWS") && string.startsWith(STANDARD_PREFIX)) {
            path3 = string.substring(STANDARD_PREFIX.length() - 2);
        } else if (string.startsWith(STANDARD_PREFIX)) {
            path3 = string.substring(STANDARD_PREFIX.length());
        } else if (string.startsWith(SIMPLE_PREFIX)) {
            path3 = string.substring(SIMPLE_PREFIX.length() - 1);
        } else {
            String auth = aURL.getAuthority();
            String path2 = aURL.getPath().replace("%20", " ");
            path3 = auth != null && !"".equals(auth) ? "//" + auth + path2 : path2;
        }
        return new File((String)path3);
    }

    public static String toString(URL aURL) throws IOException {
        try (Scanner scanner = new Scanner(aURL.openStream(), StandardCharsets.UTF_8.name());){
            String string = scanner.useDelimiter("\\A").next();
            return string;
        }
    }

    public static String decode(String aString) {
        return URLUtils.decode(aString, StandardCharsets.UTF_8.name());
    }

    public static String decode(String aURL, String aEncoding) {
        String decodedString;
        String urlString = aURL;
        try {
            while (!(urlString = URLDecoder.decode((decodedString = urlString).replaceAll("%(?![0-9a-fA-F]{2})", PERCENT), aEncoding)).equals(decodedString)) {
            }
        }
        catch (UnsupportedEncodingException details) {
            throw new UnsupportedEncodingI18nException((Throwable)details, aEncoding);
        }
        if (LOGGER.isDebugEnabled() && !aURL.equals(decodedString)) {
            LOGGER.debug("UTIL-048", (Object)aURL, (Object)decodedString);
        }
        return decodedString;
    }

    public static String encode(String aString, boolean aIgnoreSlashFlag) {
        StringCharacterIterator iterator = new StringCharacterIterator(URLUtils.decode(aString));
        StringBuilder builder = new StringBuilder();
        char c = iterator.first();
        while (c != '\uffff') {
            switch (c) {
                case '%': {
                    builder.append(PERCENT);
                    break;
                }
                case '/': {
                    if (aIgnoreSlashFlag) {
                        builder.append(c);
                        break;
                    }
                    builder.append("%2F");
                    break;
                }
                case '?': {
                    builder.append("%3F");
                    break;
                }
                case '#': {
                    builder.append("%23");
                    break;
                }
                case '[': {
                    builder.append("%5B");
                    break;
                }
                case ']': {
                    builder.append("%5D");
                    break;
                }
                case '@': {
                    builder.append("%40");
                    break;
                }
                default: {
                    builder.append(c);
                }
            }
            c = iterator.next();
        }
        return URI.create(builder.toString()).toASCIIString();
    }
}

