/*
 * Decompiled with CFR 0.152.
 */
package info.hoang8f.android.segmented;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RadioGroup;
import info.hoang8f.android.segmented.R;

public class SegmentedGroup
extends RadioGroup {
    private int oneDP;
    private Resources resources = this.getResources();
    private int mTintColor = this.resources.getColor(R.color.radio_button_selected_color);
    private int mCheckedTextColor = -1;

    public SegmentedGroup(Context context) {
        super(context);
        this.oneDP = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.resources.getDisplayMetrics());
    }

    public SegmentedGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.oneDP = (int)TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)this.resources.getDisplayMetrics());
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.updateBackground();
    }

    public void setTintColor(int tintColor) {
        this.mTintColor = tintColor;
        this.updateBackground();
    }

    public void setTintColor(int tintColor, int checkedTextColor) {
        this.mTintColor = tintColor;
        this.mCheckedTextColor = checkedTextColor;
        this.updateBackground();
    }

    public void updateBackground() {
        int count = super.getChildCount();
        if (count > 1) {
            View child = this.getChildAt(0);
            RadioGroup.LayoutParams initParams = (RadioGroup.LayoutParams)child.getLayoutParams();
            RadioGroup.LayoutParams params = new RadioGroup.LayoutParams(initParams.width, initParams.height, initParams.weight);
            if (this.getOrientation() == 0) {
                params.setMargins(0, 0, -this.oneDP, 0);
            } else {
                params.setMargins(0, 0, 0, -this.oneDP);
            }
            child.setLayoutParams((ViewGroup.LayoutParams)params);
            if (this.getOrientation() == 0) {
                this.updateBackground(this.getChildAt(0), R.drawable.radio_checked_left, R.drawable.radio_unchecked_left);
            } else {
                this.updateBackground(this.getChildAt(0), R.drawable.radio_checked_top, R.drawable.radio_unchecked_top);
            }
            for (int i = 1; i < count - 1; ++i) {
                if (this.getOrientation() == 0) {
                    this.updateBackground(this.getChildAt(i), R.drawable.radio_checked_middle, R.drawable.radio_unchecked_middle);
                } else {
                    this.updateBackground(this.getChildAt(i), R.drawable.radio_checked_middle, R.drawable.radio_unchecked_middle_vertical);
                }
                View child2 = this.getChildAt(i);
                initParams = (RadioGroup.LayoutParams)child2.getLayoutParams();
                params = new RadioGroup.LayoutParams(initParams.width, initParams.height, initParams.weight);
                if (this.getOrientation() == 0) {
                    params.setMargins(0, 0, -this.oneDP, 0);
                } else {
                    params.setMargins(0, 0, 0, -this.oneDP);
                }
                child2.setLayoutParams((ViewGroup.LayoutParams)params);
            }
            if (this.getOrientation() == 0) {
                this.updateBackground(this.getChildAt(count - 1), R.drawable.radio_checked_right, R.drawable.radio_unchecked_right);
            } else {
                this.updateBackground(this.getChildAt(count - 1), R.drawable.radio_checked_bottom, R.drawable.radio_unchecked_bottom);
            }
        } else if (count == 1) {
            this.updateBackground(this.getChildAt(0), R.drawable.radio_checked_default, R.drawable.radio_unchecked_default);
        }
    }

    private void updateBackground(View view, int checked, int unchecked) {
        ColorStateList colorStateList = new ColorStateList((int[][])new int[][]{{16842919}, {-16842919, -16842912}, {-16842919, 0x10100A0}}, new int[]{-7829368, this.mTintColor, this.mCheckedTextColor});
        ((Button)view).setTextColor(colorStateList);
        Drawable checkedDrawable = this.resources.getDrawable(checked).mutate();
        Drawable uncheckedDrawable = this.resources.getDrawable(unchecked).mutate();
        ((GradientDrawable)checkedDrawable).setColor(this.mTintColor);
        ((GradientDrawable)uncheckedDrawable).setStroke(this.oneDP, this.mTintColor);
        StateListDrawable stateListDrawable = new StateListDrawable();
        stateListDrawable.addState(new int[]{-16842912}, uncheckedDrawable);
        stateListDrawable.addState(new int[]{0x10100A0}, checkedDrawable);
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground((Drawable)stateListDrawable);
        } else {
            view.setBackgroundDrawable((Drawable)stateListDrawable);
        }
    }
}

