/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.Date$;
import isabelle.Date$Format$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.Url$;
import isabelle.package$;
import java.io.File;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public final class Build_Cygwin$ {
    public static final Build_Cygwin$ MODULE$;
    private final String default_mirror;
    private final List<String> packages;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Build_Cygwin$();
    }

    public String default_mirror() {
        return this.default_mirror;
    }

    public List<String> packages() {
        return this.packages;
    }

    public void build_cygwin(Progress progress, String mirror, List<String> more_packages) {
        Predef$.MODULE$.require(Platform$.MODULE$.is_windows());
        Isabelle_System$.MODULE$.with_tmp_dir("cygwin", new Serializable(progress, mirror, more_packages){
            public static final long serialVersionUID = 0L;
            private final Progress progress$1;
            private final String mirror$2;
            private final List more_packages$2;

            public final Process_Result apply(Path tmp_dir) {
                Path cygwin = tmp_dir.$plus(Path$.MODULE$.explode("cygwin"));
                Path cygwin_etc = cygwin.$plus(Path$.MODULE$.explode("etc"));
                Path cygwin_isabelle = cygwin.$plus(Path$.MODULE$.explode("isabelle"));
                Isabelle_System$.MODULE$.mkdirs(cygwin_isabelle);
                String cygwin_exe_name = new StringBuilder().append((Object)this.mirror$2).append((Object)"/setup-x86_64.exe").toString();
                Path cygwin_exe = cygwin_isabelle.$plus(Path$.MODULE$.explode("cygwin.exe"));
                Bytes$.MODULE$.write(cygwin_exe, this.liftedTree1$1(cygwin_exe_name));
                File$.MODULE$.write(cygwin_isabelle.$plus(Path$.MODULE$.explode("cygwin_mirror")), (CharSequence)this.mirror$2);
                File$.MODULE$.set_executable(cygwin_exe, true);
                Isabelle_System$.MODULE$.bash(new StringBuilder().append((Object)File$.MODULE$.bash_path(cygwin_exe)).append((Object)" -h </dev/null >/dev/null").toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
                List<String> list2 = Build_Cygwin$.MODULE$.packages();
                String x$2 = new StringBuilder().append((Object)File$.MODULE$.bash_path(cygwin_exe)).append((Object)" --site ").append((Object)Bash$.MODULE$.string(this.mirror$2)).append((Object)" --no-verify").append((Object)" --local-package-dir 'C:\\temp'").append((Object)" --root ").append((Object)Bash$.MODULE$.string(File$.MODULE$.platform_path(cygwin))).append((Object)" --packages ").append(package$.MODULE$.quote().apply((Object)this.more_packages$2.$colon$colon$colon(list2).mkString(","))).append((Object)" --no-shortcuts --no-startmenu --no-desktop --quiet-mode").toString();
                boolean x$3 = true;
                File x$4 = this.progress$1.bash$default$2();
                Map<String, String> x$5 = this.progress$1.bash$default$3();
                boolean x$6 = this.progress$1.bash$default$4();
                boolean x$7 = this.progress$1.bash$default$6();
                Process_Result res = this.progress$1.bash(x$2, x$4, x$5, x$6, x$3, x$7);
                Object object = res.ok() && cygwin_etc.is_dir() ? BoxedUnit.UNIT : package$.MODULE$.error().apply((Object)"Failed");
                List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"hosts", "protocols", "services", "networks", "passwd", "group"})).foreach((Function1)new Serializable(this, cygwin_etc){
                    public static final long serialVersionUID = 0L;
                    private final Path cygwin_etc$1;

                    public final boolean apply(String name2) {
                        return this.cygwin_etc$1.$plus(Path$.MODULE$.explode(name2)).file().delete();
                    }
                    {
                        this.cygwin_etc$1 = cygwin_etc$1;
                    }
                });
                cygwin.$plus(Path$.MODULE$.explode("Cygwin.bat")).file().delete();
                String archive = new StringBuilder().append((Object)"cygwin-").append((Object)Date$Format$.MODULE$.apply((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"uuuuMMdd"})).apply(Date$.MODULE$.now(Date$.MODULE$.now$default$1()))).append((Object)".tar.gz").toString();
                return Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-czf ").append((Object)Bash$.MODULE$.string(archive)).append((Object)" cygwin").toString(), tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
            }

            private final Bytes liftedTree1$1(String cygwin_exe_name$1) {
                Bytes bytes;
                try {
                    bytes = Bytes$.MODULE$.read(Url$.MODULE$.apply(cygwin_exe_name$1));
                }
                catch (Throwable throwable) {
                    Bytes bytes2;
                    Throwable throwable2 = throwable;
                    Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    bytes = bytes2 = (Bytes)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Failed to download ").append(package$.MODULE$.quote().apply((Object)cygwin_exe_name$1)).toString());
                }
                return bytes;
            }
            {
                this.progress$1 = progress$1;
                this.mirror$2 = mirror$2;
                this.more_packages$2 = more_packages$2;
            }
        });
    }

    public String build_cygwin$default$2() {
        return this.default_mirror();
    }

    public List<String> build_cygwin$default$3() {
        return Nil$.MODULE$;
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    private Build_Cygwin$() {
        MODULE$ = this;
        this.default_mirror = "https://isabelle.sketis.net/cygwin_2019";
        this.packages = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"curl", "libgmp-devel", "nano", "perl", "perl-libwww-perl", "rlwrap", "unzip"}));
        this.isabelle_tool = new Isabelle_Tool("build_cygwin", "produce pre-canned Cygwin distribution for Isabelle", (Function1<List<String>, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(List<String> args) {
                ObjectRef mirror = ObjectRef.create((Object)Build_Cygwin$.MODULE$.default_mirror());
                ObjectRef more_packages = ObjectRef.create((Object)Nil$.MODULE$);
                Getopts getopts = Getopts$.MODULE$.apply(new StringBuilder().append((Object)"\nUsage: isabelle build_cygwin [OPTIONS]\n\n  Options are:\n    -R MIRROR    Cygwin mirror site (default ").append(package$.MODULE$.quote().apply((Object)Build_Cygwin$.MODULE$.default_mirror())).append((Object)")\n    -p NAME      additional Cygwin package\n\n  Produce pre-canned Cygwin distribution for Isabelle: this requires\n  Windows administrator mode.\n").toString(), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"R:"), (Object)new Serializable(this, mirror){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef mirror$1;

                    public final void apply(String arg) {
                        this.mirror$1.elem = arg;
                    }
                    {
                        this.mirror$1 = mirror$1;
                    }
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"p:"), (Object)new Serializable(this, more_packages){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef more_packages$1;

                    public final void apply(String arg) {
                        this.more_packages$1.elem = ((List)this.more_packages$1.elem).$colon$colon((Object)arg);
                    }
                    {
                        this.more_packages$1 = more_packages$1;
                    }
                })}));
                List<String> more_args = getopts.apply(args);
                if (more_args.nonEmpty()) {
                    throw getopts.usage();
                }
                Build_Cygwin$.MODULE$.build_cygwin(new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2()), (String)mirror.elem, (List<String>)((List)more_packages.elem));
            }
        });
    }
}

