/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Build_JDK;
import isabelle.Build_JDK$$anonfun$build_jdk$1$;
import isabelle.Components$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.No_Progress$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.Process_Result;
import isabelle.Progress;
import isabelle.package$;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class Build_JDK$ {
    public static final Build_JDK$ MODULE$;
    private final List<Build_JDK.JDK_Platform> jdk_platforms;
    private final String settings;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Build_JDK$();
    }

    public String detect_version(String s) {
        String version;
        String string2;
        Regex Version_Dir_Entry = new StringOps(Predef$.MODULE$.augmentString("^jdk-([0-9.]+\\+\\d+)$")).r();
        Option option2 = Version_Dir_Entry.unapplySeq((CharSequence)(string2 = s));
        String string3 = !option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 ? (version = (String)((LinearSeqOptimized)option2.get()).apply(0)) : (String)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Cannot detect JDK version from ").append(package$.MODULE$.quote().apply((Object)s)).toString());
        return string3;
    }

    public List<Build_JDK.JDK_Platform> jdk_platforms() {
        return this.jdk_platforms;
    }

    public String readme(String version) {
        return new StringBuilder().append((Object)"This is OpenJDK ").append((Object)version).append((Object)" as required for Isabelle.\n\nSee https://adoptopenjdk.net for the original downloads, which are covered\nthe GPL2 (with various liberal exceptions, see legal/*).\n\nLinux, Windows, Mac OS X all work uniformly, depending on certain\nplatform-specific subdirectories.\n").toString();
    }

    public String settings() {
        return this.settings;
    }

    public boolean isabelle$Build_JDK$$suppress_name(String name2) {
        return name2.startsWith("._");
    }

    public Tuple2<String, Build_JDK.JDK_Platform> extract_archive(Path dir, Path archive) {
        try {
            String s;
            Path tmp_dir = dir.$plus(Path$.MODULE$.explode("tmp"));
            Isabelle_System$.MODULE$.mkdirs(tmp_dir);
            String string2 = archive.get_ext();
            String string3 = "zip";
            Process_Result process_Result = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Isabelle_System$.MODULE$.bash(new StringBuilder().append((Object)"unzip -x ").append((Object)File$.MODULE$.bash_path(archive.absolute())).toString(), tmp_dir.file(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check() : Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-xzf ").append((Object)File$.MODULE$.bash_path(archive)).toString(), tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
            List list2 = (List)File$.MODULE$.read_dir(tmp_dir).filterNot((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return Build_JDK$.MODULE$.isabelle$Build_JDK$$suppress_name(x$1);
                }
            });
            Some some = List$.MODULE$.unapplySeq((Seq)list2);
            String string4 = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (s = (String)((LinearSeqOptimized)some.get()).apply(0)) : (String)package$.MODULE$.error().apply((Object)"Archive contains multiple directories");
            String dir_entry = string4;
            String version = this.detect_version(dir_entry);
            Path jdk_dir = tmp_dir.$plus(Path$.MODULE$.explode(dir_entry));
            Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)this.jdk_platforms().find((Function1)new Serializable(jdk_dir){
                public static final long serialVersionUID = 0L;
                private final Path jdk_dir$1;

                public final boolean apply(Build_JDK.JDK_Platform x$2) {
                    return x$2.detect(this.jdk_dir$1);
                }
                {
                    this.jdk_dir$1 = jdk_dir$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    return (Nothing$)package$.MODULE$.error().apply((Object)"Failed to detect JDK platform");
                }
            });
            Path platform_dir = dir.$plus(Path$.MODULE$.explode(platform.name()));
            Object object = platform_dir.is_dir() ? package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Directory already exists: ").append((Object)platform_dir).toString()) : BoxedUnit.UNIT;
            File$.MODULE$.link(Path$.MODULE$.current(), jdk_dir.$plus(Path$.MODULE$.explode(platform.home())).$plus(Path$.MODULE$.explode("jre")), File$.MODULE$.link$default$3());
            File$.MODULE$.move(jdk_dir, platform_dir);
            return new Tuple2((Object)version, (Object)platform);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            String msg = (String)option2.get();
            throw package$.MODULE$.cat_error((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{msg, new StringBuilder().append((Object)"The error(s) above occurred for ").append((Object)archive).toString()}));
        }
    }

    public void build_jdk(List<Path> archives, Progress progress, Path target_dir) {
        Object object = Platform$.MODULE$.is_windows() ? package$.MODULE$.error().apply((Object)"Cannot build jdk on Windows") : BoxedUnit.UNIT;
        Isabelle_System$.MODULE$.with_tmp_dir("jdk", new Serializable(archives, progress, target_dir){
            public static final long serialVersionUID = 0L;
            private final List archives$1;
            private final Progress progress$1;
            private final Path target_dir$2;

            public final Process_Result apply(Path dir) {
                String version;
                this.progress$1.echo("Extracting ...");
                List extracted = (List)this.archives$1.map((Function1)new Serializable(this, dir){
                    public static final long serialVersionUID = 0L;
                    private final Path dir$1;

                    public final Tuple2<String, Build_JDK.JDK_Platform> apply(Path x$3) {
                        return Build_JDK$.MODULE$.extract_archive(this.dir$1, x$3);
                    }
                    {
                        this.dir$1 = dir$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                List list2 = ((TraversableOnce)extracted.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Tuple2<String, Build_JDK.JDK_Platform> x$4) {
                        return (String)x$4._1();
                    }
                }, List$.MODULE$.canBuildFrom())).toSet().toList();
                Some some = List$.MODULE$.unapplySeq((Seq)list2);
                String string2 = !some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(1) == 0 ? (version = (String)((LinearSeqOptimized)some.get()).apply(0)) : (Nil$.MODULE$.equals(list2) ? (String)package$.MODULE$.error().apply((Object)"No archives") : (String)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Archives contain multiple JDK versions: ").append(package$.MODULE$.commas_quote().apply((Object)list2)).toString()));
                String version2 = string2;
                List missing_platforms = (List)Build_JDK$.MODULE$.jdk_platforms().filterNot((Function1)new Serializable(this, extracted){
                    public static final long serialVersionUID = 0L;
                    private final List extracted$1;

                    public final boolean apply(Build_JDK.JDK_Platform p1) {
                        return this.extracted$1.exists((Function1)new Serializable(this, p1){
                            public static final long serialVersionUID = 0L;
                            private final Build_JDK.JDK_Platform p1$1;

                            public final boolean apply(Tuple2<String, Build_JDK.JDK_Platform> x0$1) {
                                Tuple2<String, Build_JDK.JDK_Platform> tuple2 = x0$1;
                                if (tuple2 != null) {
                                    Build_JDK.JDK_Platform p2 = (Build_JDK.JDK_Platform)tuple2._2();
                                    String string2 = this.p1$1.name();
                                    String string3 = p2.name();
                                    boolean bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
                                    return bl;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.p1$1 = p1$1;
                            }
                        });
                    }
                    {
                        this.extracted$1 = extracted$1;
                    }
                });
                Object object = missing_platforms.nonEmpty() ? package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Missing platforms: ").append(package$.MODULE$.commas_quote().apply(missing_platforms.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Build_JDK.JDK_Platform x$5) {
                        return x$5.name();
                    }
                }, List$.MODULE$.canBuildFrom()))).toString()) : BoxedUnit.UNIT;
                String jdk_name = new StringBuilder().append((Object)"jdk-").append((Object)version2).toString();
                Path jdk_path = Path$.MODULE$.explode(jdk_name);
                Path component_dir = dir.$plus(jdk_path);
                Isabelle_System$.MODULE$.mkdirs(component_dir.$plus(Path$.MODULE$.explode("etc")));
                File$.MODULE$.write(Components$.MODULE$.settings(component_dir), (CharSequence)Build_JDK$.MODULE$.settings());
                File$.MODULE$.write(component_dir.$plus(Path$.MODULE$.explode("README")), (CharSequence)Build_JDK$.MODULE$.readme(version2));
                extracted.withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Build_JDK.JDK_Platform> check$ifrefutable$1) {
                        Tuple2<String, Build_JDK.JDK_Platform> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, component_dir, dir){
                    public static final long serialVersionUID = 0L;
                    private final Path component_dir$1;
                    private final Path dir$1;

                    public final void apply(Tuple2<String, Build_JDK.JDK_Platform> x$6) {
                        Tuple2<String, Build_JDK.JDK_Platform> tuple2 = x$6;
                        if (tuple2 != null) {
                            Build_JDK.JDK_Platform platform = (Build_JDK.JDK_Platform)tuple2._2();
                            File$.MODULE$.move(this.dir$1.$plus(Path$.MODULE$.explode(platform.name())), this.component_dir$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.component_dir$1 = component_dir$1;
                        this.dir$1 = dir$1;
                    }
                });
                File x$11 = component_dir.file();
                boolean x$12 = true;
                Function1<File, Object> x$13 = File$.MODULE$.find_files$default$2();
                boolean x$14 = File$.MODULE$.find_files$default$4();
                File$.MODULE$.find_files(x$11, x$13, x$12, x$14).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final java.nio.file.Path apply(File file) {
                        Object object;
                        java.nio.file.Path path2 = file.toPath();
                        Set<PosixFilePermission> perms = Files.getPosixFilePermissions(path2, new LinkOption[0]);
                        perms.add(PosixFilePermission.OWNER_READ);
                        perms.add(PosixFilePermission.GROUP_READ);
                        perms.add(PosixFilePermission.OTHERS_READ);
                        perms.add(PosixFilePermission.OWNER_WRITE);
                        if (file.isDirectory()) {
                            perms.add(PosixFilePermission.OWNER_WRITE);
                            perms.add(PosixFilePermission.OWNER_EXECUTE);
                            perms.add(PosixFilePermission.GROUP_EXECUTE);
                            object = BoxesRunTime.boxToBoolean((boolean)perms.add(PosixFilePermission.OTHERS_EXECUTE));
                        } else {
                            object = BoxedUnit.UNIT;
                        }
                        return Files.setPosixFilePermissions(path2, perms);
                    }
                });
                File$.MODULE$.find_files(component_dir.$plus(Path$.MODULE$.explode("x86_64-darwin")).file(), (Function1<File, Object>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File file) {
                        return Build_JDK$.MODULE$.isabelle$Build_JDK$$suppress_name(file.getName());
                    }
                }, File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(File x$7) {
                        return x$7.delete();
                    }
                });
                this.progress$1.echo("Sharing ...");
                List list3 = (List)Build_JDK$.MODULE$.jdk_platforms().map((Function1)new Serializable(this, component_dir){
                    public static final long serialVersionUID = 0L;
                    private final Path component_dir$1;

                    public final java.nio.file.Path apply(Build_JDK.JDK_Platform platform) {
                        return this.component_dir$1.$plus(Path$.MODULE$.explode(platform.name())).file().toPath();
                    }
                    {
                        this.component_dir$1 = component_dir$1;
                    }
                }, List$.MODULE$.canBuildFrom());
                if (list3 instanceof .colon.colon) {
                    Tuple2 tuple2;
                    .colon.colon colon2 = (.colon.colon)list3;
                    java.nio.file.Path main_dir = (java.nio.file.Path)colon2.head();
                    List other_dirs = colon2.tl$1();
                    Tuple2 tuple22 = tuple2 = new Tuple2((Object)main_dir, (Object)other_dirs);
                    java.nio.file.Path main_dir2 = (java.nio.file.Path)tuple22._1();
                    List other_dirs2 = (List)tuple22._2();
                    File$.MODULE$.find_files(main_dir2.toFile(), File$.MODULE$.find_files$default$2(), File$.MODULE$.find_files$default$3(), File$.MODULE$.find_files$default$4()).iterator().map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<File, java.nio.file.Path> apply(File file1) {
                            java.nio.file.Path path1 = file1.toPath();
                            return new Tuple2((Object)file1, (Object)path1);
                        }
                    }).foreach((Function1)new Serializable(this, main_dir2, other_dirs2){
                        public static final long serialVersionUID = 0L;
                        public final java.nio.file.Path main_dir$1;
                        private final List other_dirs$1;

                        public final void apply(Tuple2<File, java.nio.file.Path> x$9) {
                            Tuple2<File, java.nio.file.Path> tuple2 = x$9;
                            if (tuple2 != null) {
                                File file1 = (File)tuple2._1();
                                java.nio.file.Path path1 = (java.nio.file.Path)tuple2._2();
                                this.other_dirs$1.iterator().foreach((Function1)new Serializable(this, file1, path1){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$build_jdk$1$$anonfun$apply$9 $outer;
                                    private final File file1$1;
                                    private final java.nio.file.Path path1$1;

                                    public final Object apply(java.nio.file.Path dir2) {
                                        Object object;
                                        java.nio.file.Path path2 = dir2.resolve(this.$outer.main_dir$1.relativize(this.path1$1));
                                        File file2 = path2.toFile();
                                        if (!Files.isSymbolicLink(path2) && file2.isFile() && File$.MODULE$.eq_content(this.file1$1, file2)) {
                                            file2.delete();
                                            object = Files.createLink(path2, this.path1$1);
                                        } else {
                                            object = BoxedUnit.UNIT;
                                        }
                                        return object;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw null;
                                        }
                                        this.$outer = $outer;
                                        this.file1$1 = file1$1;
                                        this.path1$1 = path1$1;
                                    }
                                });
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                return;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.main_dir$1 = main_dir$1;
                            this.other_dirs$1 = other_dirs$1;
                        }
                    });
                    this.progress$1.echo("Archiving ...");
                    return Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-czf ").append((Object)File$.MODULE$.bash_path(this.target_dir$2.$plus(jdk_path.ext("tar.gz")))).append((Object)" ").append((Object)jdk_name).toString(), dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
                }
                throw new MatchError((Object)list3);
            }
            {
                this.archives$1 = archives$1;
                this.progress$1 = progress$1;
                this.target_dir$2 = target_dir$2;
            }
        });
    }

    public Progress build_jdk$default$2() {
        return No_Progress$.MODULE$;
    }

    public Path build_jdk$default$3() {
        return Path$.MODULE$.current();
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    private Build_JDK$() {
        MODULE$ = this;
        this.jdk_platforms = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Build_JDK.JDK_Platform[]{new Build_JDK.JDK_Platform("x86_64-linux", ".", "bin/java", new StringOps(Predef$.MODULE$.augmentString(".*ELF 64-bit.*x86[-_]64.*")).r()), new Build_JDK.JDK_Platform("x86_64-windows", ".", "bin/java.exe", new StringOps(Predef$.MODULE$.augmentString(".*PE32\\+ executable.*x86[-_]64.*")).r()), new Build_JDK.JDK_Platform("x86_64-darwin", "Contents/Home", "Contents/Home/bin/java", new StringOps(Predef$.MODULE$.augmentString(".*Mach-O 64-bit.*x86[-_]64.*")).r())}));
        this.settings = "# -*- shell-script -*- :mode=shellscript:\n\ncase \"$ISABELLE_PLATFORM_FAMILY\" in\n  linux)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  windows)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_WINDOWS_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM\"\n    ;;\n  macos)\n    ISABELLE_JAVA_PLATFORM=\"$ISABELLE_PLATFORM64\"\n    ISABELLE_JDK_HOME=\"$COMPONENT/$ISABELLE_JAVA_PLATFORM/Contents/Home\"\n    ;;\nesac\n";
        this.isabelle_tool = new Isabelle_Tool("build_jdk", "build Isabelle jdk component from original archives", (Function1<List<String>, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(List<String> args) {
                ObjectRef target_dir = ObjectRef.create((Object)Path$.MODULE$.current());
                Getopts getopts = Getopts$.MODULE$.apply("\nUsage: isabelle build_jdk [OPTIONS] ARCHIVES...\n\n  Options are:\n    -D DIR       target directory (default \".\")\n\n  Build jdk component from tar.gz archives, with original jdk archives\n  for x86_64 Linux, Windows, Mac OS X.\n", (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"D:"), (Object)new Serializable(this, target_dir){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef target_dir$1;

                    public final void apply(String arg) {
                        this.target_dir$1.elem = Path$.MODULE$.explode(arg);
                    }
                    {
                        this.target_dir$1 = target_dir$1;
                    }
                })}));
                List<String> more_args = getopts.apply(args);
                if (more_args.isEmpty()) {
                    throw getopts.usage();
                }
                List archives = (List)more_args.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(String x$10) {
                        return Path$.MODULE$.explode(x$10);
                    }
                }, List$.MODULE$.canBuildFrom());
                Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
                Build_JDK$.MODULE$.build_jdk((List<Path>)archives, progress, (Path)target_dir.elem);
            }
        });
    }
}

