/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes$;
import isabelle.Components;
import isabelle.Components$;
import isabelle.Components$Archive$;
import isabelle.Console_Progress;
import isabelle.Console_Progress$;
import isabelle.File$;
import isabelle.Getopts;
import isabelle.Getopts$;
import isabelle.Isabelle_System$;
import isabelle.Isabelle_Tool;
import isabelle.Library$;
import isabelle.No_Progress$;
import isabelle.Options;
import isabelle.Options$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$Family$;
import isabelle.Progress;
import isabelle.SHA1$;
import isabelle.SSH;
import isabelle.SSH$;
import isabelle.SSH$Target$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.package$;
import java.io.File;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class Components$ {
    public static final Components$ MODULE$;
    private final Path default_components_base;
    private final Path components_sha1;
    private final List<String> isabelle$Components$$relevant_options;
    private final Isabelle_Tool isabelle_tool;

    static {
        new Components$();
    }

    public Path default_components_base() {
        return this.default_components_base;
    }

    public Path admin(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("Admin/components"));
    }

    public Path contrib(Path dir, String name2) {
        return dir.$plus(Path$.MODULE$.explode("contrib")).$plus(Path$.MODULE$.explode(name2));
    }

    public Path contrib$default$1() {
        return Path$.MODULE$.current();
    }

    public String contrib$default$2() {
        return "";
    }

    public String unpack(Path dir, Path archive, Progress progress) {
        String name2 = Components$Archive$.MODULE$.get_name(archive.file_name());
        progress.echo(new StringBuilder().append((Object)"Unpacking ").append((Object)name2).toString());
        Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-xzf ").append((Object)File$.MODULE$.bash_path(archive)).toString(), dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
        return name2;
    }

    public Progress unpack$default$3() {
        return No_Progress$.MODULE$;
    }

    public void resolve(Path base_dir, List<String> names, Option<Path> target_dir, Progress progress) {
        Isabelle_System$.MODULE$.mkdirs(base_dir);
        names.foreach((Function1)new Serializable(base_dir, target_dir, progress){
            public static final long serialVersionUID = 0L;
            public final Path base_dir$1;
            private final Option target_dir$1;
            private final Progress progress$1;

            public final String apply(String name2) {
                String archive_name = Components$Archive$.MODULE$.apply(name2);
                Path archive = this.base_dir$1.$plus(Path$.MODULE$.explode(archive_name));
                if (!archive.is_file()) {
                    String remote = new StringBuilder().append((Object)Isabelle_System$.MODULE$.getenv("ISABELLE_COMPONENT_REPOSITORY", Isabelle_System$.MODULE$.getenv$default$2())).append((Object)"/").append((Object)archive_name).toString();
                    this.progress$1.echo(new StringBuilder().append((Object)"Getting ").append((Object)remote).toString());
                    Bytes$.MODULE$.write(archive, Url$.MODULE$.read_bytes(Url$.MODULE$.apply(remote)));
                }
                return Components$.MODULE$.unpack((Path)this.target_dir$1.getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.resolve.1 $outer;

                    public final Path apply() {
                        return this.$outer.base_dir$1;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }), archive, this.progress$1);
            }
            {
                this.base_dir$1 = base_dir$1;
                this.target_dir$1 = target_dir$1;
                this.progress$1 = progress$1;
            }
        });
    }

    public Option<Path> resolve$default$3() {
        return None$.MODULE$;
    }

    public Progress resolve$default$4() {
        return No_Progress$.MODULE$;
    }

    public void purge(Path dir, Enumeration.Value platform) {
        Enumeration.Value value2;
        block5: {
            Set set2;
            block3: {
                block4: {
                    block2: {
                        value2 = platform;
                        Enumeration.Value value3 = Platform$Family$.MODULE$.linux();
                        Enumeration.Value value4 = value2;
                        if (value3 != null ? !value3.equals(value4) : value4 != null) break block2;
                        set2 = this.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"darwin", "cygwin", "windows"}));
                        break block3;
                    }
                    Enumeration.Value value5 = Platform$Family$.MODULE$.macos();
                    Enumeration.Value value6 = value2;
                    if (value5 != null ? !value5.equals(value6) : value6 != null) break block4;
                    set2 = this.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux", "cygwin", "windows"}));
                    break block3;
                }
                Enumeration.Value value7 = Platform$Family$.MODULE$.windows();
                Enumeration.Value value8 = value2;
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block5;
                set2 = this.purge_platforms$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"linux", "darwin"}));
            }
            Set purge_set = set2;
            File$.MODULE$.find_files(dir.file(), (Function1<File, Object>)new Serializable(purge_set){
                public static final long serialVersionUID = 0L;
                private final Set purge_set$1;

                public final boolean apply(File file) {
                    return file.isDirectory() && this.purge_set$1.apply((Object)file.getName());
                }
                {
                    this.purge_set$1 = purge_set$1;
                }
            }, true, File$.MODULE$.find_files$default$4()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(File root) {
                    Isabelle_System$.MODULE$.rm_tree(root);
                }
            });
            return;
        }
        throw new MatchError((Object)value2);
    }

    public Path settings(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("etc/settings"));
    }

    public Path settings$default$1() {
        return Path$.MODULE$.current();
    }

    public Path components(Path dir) {
        return dir.$plus(Path$.MODULE$.explode("etc/components"));
    }

    public Path components$default$1() {
        return Path$.MODULE$.current();
    }

    public boolean check_dir(Path dir) {
        return this.settings(dir).is_file() || this.components(dir).is_file();
    }

    public List<String> read_components(Path dir) {
        return (List)((TraversableLike)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(this.components(dir)))).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
            }
        });
    }

    public void write_components(Path dir, List<String> lines) {
        File$.MODULE$.write(this.components(dir), (CharSequence)package$.MODULE$.terminate_lines().apply(lines));
    }

    public Path components_sha1() {
        return this.components_sha1;
    }

    public List<Components.SHA1_Digest> read_components_sha1(List<String> lines) {
        return (List)((List)package$.MODULE$.proper_list(lines).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply() {
                return (List)package$.MODULE$.split_lines().apply((Object)File$.MODULE$.read(Components$.MODULE$.components_sha1()));
            }
        })).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Iterable<Components.SHA1_Digest> apply(String line) {
                Iterable iterable;
                List<String> list2 = Word$.MODULE$.explode(line);
                if (Nil$.MODULE$.equals(list2)) {
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    Some some = List$.MODULE$.unapplySeq(list2);
                    if (!some.isEmpty() && some.get() != null && ((LinearSeqOptimized)some.get()).lengthCompare(2) == 0) {
                        String sha1 = (String)((LinearSeqOptimized)some.get()).apply(0);
                        String name2 = (String)((LinearSeqOptimized)some.get()).apply(1);
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Components.SHA1_Digest(sha1, name2)));
                    } else {
                        iterable = (Iterable)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad components.sha1 entry: ").append(package$.MODULE$.quote().apply((Object)line)).toString());
                    }
                }
                return iterable;
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public List<String> read_components_sha1$default$1() {
        return Nil$.MODULE$;
    }

    public void write_components_sha1(List<Components.SHA1_Digest> entries2) {
        File$.MODULE$.write(this.components_sha1(), (CharSequence)((TraversableOnce)entries2.sortBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Components.SHA1_Digest x$2) {
                return x$2.file_name();
            }
        }, (Ordering)Ordering.String$.MODULE$)).mkString("", "\n", "\n"));
    }

    public void build_components(Options options2, List<Path> components, Progress progress, boolean publish, boolean force, boolean update_components_sha1) {
        List archives = (List)components.map((Function1)new Serializable(progress, force){
            public static final long serialVersionUID = 0L;
            private final Progress progress$2;
            private final boolean force$2;

            public final Path apply(Path path2) {
                Path path3;
                String string2 = path2.file_name();
                Option<String> option2 = Components$Archive$.MODULE$.unapply(string2);
                if (option2.isEmpty()) {
                    Path path4;
                    if (path2.is_dir()) {
                        if (Components$.MODULE$.check_dir(path2)) {
                            String archive_name;
                            Path component_path = path2.expand();
                            Path archive_dir = component_path.dir();
                            Path archive = archive_dir.$plus(Path$.MODULE$.explode(archive_name = Components$Archive$.MODULE$.apply(string2)));
                            Object object = archive.is_file() && !this.force$2 ? package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Component archive already exists: ").append((Object)archive).toString()) : BoxedUnit.UNIT;
                            this.progress$2.echo(new StringBuilder().append((Object)"Packaging ").append((Object)archive_name).toString());
                            Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-czf ").append((Object)File$.MODULE$.bash_path(archive)).append((Object)" ").append((Object)Bash$.MODULE$.string(string2)).toString(), archive_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
                            path4 = archive;
                        } else {
                            path4 = (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Malformed component directory: ").append((Object)path2).append((Object)"\n  (requires ").append((Object)Components$.MODULE$.settings(Components$.MODULE$.settings$default$1())).append((Object)" or ").append((Object)Components$.MODULE$.components(Components$.MODULE$.components$default$1())).append((Object)")").toString());
                        }
                    } else {
                        path4 = (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad component directory: ").append((Object)path2).toString());
                    }
                    path3 = path4;
                } else {
                    path3 = path2;
                }
                return path3;
            }
            {
                this.progress$2 = progress$2;
                this.force$2 = force$2;
            }
        }, List$.MODULE$.canBuildFrom());
        if (publish && archives.nonEmpty() || update_components_sha1) {
            String string2 = options2.string().apply("isabelle_components_server");
            Option<List<String>> option2 = SSH$Target$.MODULE$.unapplySeq(string2);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String user = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String host = (String)((LinearSeqOptimized)option2.get()).apply(1);
                BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.using(SSH$.MODULE$.open_session(options2, host, user, SSH$.MODULE$.open_session$default$4(), SSH$.MODULE$.open_session$default$5(), SSH$.MODULE$.open_session$default$6(), SSH$.MODULE$.open_session$default$7(), SSH$.MODULE$.open_session$default$8()), new Serializable(options2, progress, publish, force, update_components_sha1, archives){
                    public static final long serialVersionUID = 0L;
                    private final Options options$2;
                    public final Progress progress$2;
                    private final boolean publish$2;
                    public final boolean force$2;
                    private final boolean update_components_sha1$2;
                    private final List archives$1;

                    public final void apply(SSH.Session ssh) {
                        Path components_dir = Path$.MODULE$.explode(this.options$2.string().apply("isabelle_components_dir"));
                        Path contrib_dir = Path$.MODULE$.explode(this.options$2.string().apply("isabelle_components_contrib_dir"));
                        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{components_dir, contrib_dir})).withFilter((Function1)new Serializable(this, ssh){
                            public static final long serialVersionUID = 0L;
                            private final SSH.Session ssh$1;

                            public final boolean apply(Path dir) {
                                return !this.ssh$1.is_dir(dir);
                            }
                            {
                                this.ssh$1 = ssh$1;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Nothing$ apply(Path dir) {
                                return (Nothing$)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad remote directory: ").append((Object)dir).toString());
                            }
                        });
                        if (this.publish$2) {
                            this.archives$1.foreach((Function1)new Serializable(this, components_dir, contrib_dir, ssh){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.build_components.1 $outer;
                                private final Path components_dir$1;
                                private final Path contrib_dir$1;
                                private final SSH.Session ssh$1;

                                public final Object apply(Path archive) {
                                    Object object;
                                    String archive_name = archive.file_name();
                                    String name2 = Components$Archive$.MODULE$.get_name(archive_name);
                                    Path remote_component = this.components_dir$1.$plus(archive.base());
                                    Path remote_contrib = this.contrib_dir$1.$plus(Path$.MODULE$.explode(name2));
                                    Object object2 = this.ssh$1.is_file(remote_component) && !this.$outer.force$2 ? package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Remote component archive already exists: ").append((Object)remote_component).toString()) : BoxedUnit.UNIT;
                                    this.$outer.progress$2.echo(new StringBuilder().append((Object)"Uploading ").append((Object)archive_name).toString());
                                    this.ssh$1.write_file(remote_component, archive);
                                    boolean is_standard_component = BoxesRunTime.unboxToBoolean(Isabelle_System$.MODULE$.with_tmp_dir("component", new Serializable(this, name2, archive){
                                        public static final long serialVersionUID = 0L;
                                        private final String name$1;
                                        private final Path archive$2;

                                        public final boolean apply(Path tmp_dir) {
                                            Isabelle_System$.MODULE$.gnutar(new StringBuilder().append((Object)"-xzf ").append((Object)File$.MODULE$.bash_path(this.archive$2)).toString(), tmp_dir, Isabelle_System$.MODULE$.gnutar$default$3(), Isabelle_System$.MODULE$.gnutar$default$4()).check();
                                            return Components$.MODULE$.check_dir(tmp_dir.$plus(Path$.MODULE$.explode(this.name$1)));
                                        }
                                        {
                                            this.name$1 = name$1;
                                            this.archive$2 = archive$2;
                                        }
                                    }));
                                    if (is_standard_component) {
                                        Object object3;
                                        if (this.ssh$1.is_dir(remote_contrib)) {
                                            if (this.$outer.force$2) {
                                                this.ssh$1.rm_tree(remote_contrib);
                                                object3 = BoxedUnit.UNIT;
                                            } else {
                                                object3 = package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Remote component directory already exists: ").append((Object)remote_contrib).toString());
                                            }
                                        } else {
                                            object3 = BoxedUnit.UNIT;
                                        }
                                        this.$outer.progress$2.echo(new StringBuilder().append((Object)"Unpacking remote ").append((Object)archive_name).toString());
                                        object = this.ssh$1.execute(new StringBuilder().append((Object)"tar -C ").append((Object)this.ssh$1.bash_path(this.contrib_dir$1)).append((Object)" -xzf ").append((Object)this.ssh$1.bash_path(remote_component)).toString(), this.ssh$1.execute$default$2(), this.ssh$1.execute$default$3(), this.ssh$1.execute$default$4()).check();
                                    } else {
                                        this.$outer.progress$2.echo_warning(new StringBuilder().append((Object)"No unpacking of non-standard component: ").append((Object)archive_name).toString());
                                        object = BoxedUnit.UNIT;
                                    }
                                    return object;
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.components_dir$1 = components_dir$1;
                                    this.contrib_dir$1 = contrib_dir$1;
                                    this.ssh$1 = ssh$1;
                                }
                            });
                        }
                        if (this.update_components_sha1$2) {
                            List lines = (List)ssh.read_dir(components_dir).withFilter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(SSH.Dir_Entry entry) {
                                    return entry.is_file() && entry.name().endsWith(Components$Archive$.MODULE$.suffix());
                                }
                            }).map((Function1)new Serializable(this, components_dir, ssh){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun.build_components.1 $outer;
                                private final Path components_dir$1;
                                private final SSH.Session ssh$1;

                                public final String apply(SSH.Dir_Entry entry) {
                                    this.$outer.progress$2.echo(new StringBuilder().append((Object)"Digesting remote ").append((Object)entry.name()).toString());
                                    return Library$.MODULE$.trim_line(this.ssh$1.execute(new StringBuilder().append((Object)"cd ").append((Object)this.ssh$1.bash_path(this.components_dir$1)).append((Object)"; sha1sum ").append((Object)Bash$.MODULE$.string(entry.name())).toString(), this.ssh$1.execute$default$2(), this.ssh$1.execute$default$3(), this.ssh$1.execute$default$4()).check().out());
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.components_dir$1 = components_dir$1;
                                    this.ssh$1 = ssh$1;
                                }
                            }, List$.MODULE$.canBuildFrom());
                            Components$.MODULE$.write_components_sha1(Components$.MODULE$.read_components_sha1((List<String>)lines));
                        }
                    }
                    {
                        this.options$2 = options$2;
                        this.progress$2 = progress$2;
                        this.publish$2 = publish$2;
                        this.force$2 = force$2;
                        this.update_components_sha1$2 = update_components_sha1$2;
                        this.archives$1 = archives$1;
                    }
                });
            } else {
                BoxedUnit boxedUnit = (BoxedUnit)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Bad isabelle_components_server: ").append(package$.MODULE$.quote().apply((Object)string2)).toString());
            }
        }
        List new_entries = (List)archives.map((Function1)new Serializable(progress){
            public static final long serialVersionUID = 0L;
            private final Progress progress$2;

            public final Components.SHA1_Digest apply(Path archive) {
                String file_name = archive.file_name();
                this.progress$2.echo(new StringBuilder().append((Object)"Digesting local ").append((Object)file_name).toString());
                String sha1 = SHA1$.MODULE$.digest(archive).rep();
                return new Components.SHA1_Digest(sha1, file_name);
            }
            {
                this.progress$2 = progress$2;
            }
        }, List$.MODULE$.canBuildFrom());
        Set new_names = ((TraversableOnce)new_entries.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Components.SHA1_Digest x$3) {
                return x$3.file_name();
            }
        }, List$.MODULE$.canBuildFrom())).toSet();
        List list2 = new_entries;
        this.write_components_sha1((List<Components.SHA1_Digest>)((List)this.read_components_sha1(this.read_components_sha1$default$1()).filterNot((Function1)new Serializable(new_names){
            public static final long serialVersionUID = 0L;
            private final Set new_names$1;

            public final boolean apply(Components.SHA1_Digest entry) {
                return this.new_names$1.contains((Object)entry.file_name());
            }
            {
                this.new_names$1 = new_names$1;
            }
        })).$colon$colon$colon(list2));
    }

    public Progress build_components$default$3() {
        return No_Progress$.MODULE$;
    }

    public boolean build_components$default$4() {
        return false;
    }

    public boolean build_components$default$5() {
        return false;
    }

    public boolean build_components$default$6() {
        return false;
    }

    public List<String> isabelle$Components$$relevant_options() {
        return this.isabelle$Components$$relevant_options;
    }

    public Isabelle_Tool isabelle_tool() {
        return this.isabelle_tool;
    }

    private final Set purge_platforms$1(Seq platforms) {
        return (Set)((TraversableOnce)platforms.flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(String name2) {
                return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder().append((Object)"x86-").append((Object)name2).toString(), new StringBuilder().append((Object)"x86_64_32-").append((Object)name2).toString(), new StringBuilder().append((Object)"x86_64-").append((Object)name2).toString()}));
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet().$plus((Object)"ppc-darwin");
    }

    private Components$() {
        MODULE$ = this;
        this.default_components_base = Path$.MODULE$.explode("$ISABELLE_COMPONENTS_BASE");
        this.components_sha1 = Path$.MODULE$.explode("~~/Admin/components/components.sha1");
        this.isabelle$Components$$relevant_options = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"isabelle_components_server", "isabelle_components_dir", "isabelle_components_contrib_dir"}));
        this.isabelle_tool = new Isabelle_Tool("build_components", "build and publish Isabelle components", (Function1<List<String>, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(List<String> args) {
                BooleanRef publish = BooleanRef.create((boolean)false);
                BooleanRef update_components_sha1 = BooleanRef.create((boolean)false);
                BooleanRef force = BooleanRef.create((boolean)false);
                ObjectRef options2 = ObjectRef.create((Object)Options$.MODULE$.init(Options$.MODULE$.init$default$1(), Options$.MODULE$.init$default$2()));
                Getopts getopts = Getopts$.MODULE$.apply(new StringBuilder().append((Object)"\nUsage: isabelle build_components [OPTIONS] ARCHIVES... DIRS...\n\n  Options are:\n    -P           publish on SSH server (see options below)\n    -f           force: overwrite existing component archives and directories\n    -o OPTION    override Isabelle system OPTION (via NAME=VAL or NAME)\n    -u           update all SHA1 keys in Isabelle repository Admin/components\n\n  Build and publish Isabelle components as .tar.gz archives on SSH server,\n  depending on system options:\n\n").append((Object)Library$.MODULE$.prefix_lines("  ", this.show_options$1(options2))).append((Object)"\n").toString(), (Seq<Tuple2<String, Function1<String, BoxedUnit>>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"P"), (Object)new Serializable(this, publish){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef publish$1;

                    public final void apply(String x$5) {
                        this.publish$1.elem = true;
                    }
                    {
                        this.publish$1 = publish$1;
                    }
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"f"), (Object)new Serializable(this, force){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef force$1;

                    public final void apply(String x$6) {
                        this.force$1.elem = true;
                    }
                    {
                        this.force$1 = force$1;
                    }
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"o:"), (Object)new Serializable(this, options2){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef options$1;

                    public final void apply(String arg) {
                        this.options$1.elem = ((Options)this.options$1.elem).$plus(arg);
                    }
                    {
                        this.options$1 = options$1;
                    }
                }), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"u"), (Object)new Serializable(this, update_components_sha1){
                    public static final long serialVersionUID = 0L;
                    private final BooleanRef update_components_sha1$1;

                    public final void apply(String x$7) {
                        this.update_components_sha1$1.elem = true;
                    }
                    {
                        this.update_components_sha1$1 = update_components_sha1$1;
                    }
                })}));
                List<String> more_args = getopts.apply(args);
                if (more_args.isEmpty() && !update_components_sha1.elem) {
                    throw getopts.usage();
                }
                Console_Progress progress = new Console_Progress(Console_Progress$.MODULE$.$lessinit$greater$default$1(), Console_Progress$.MODULE$.$lessinit$greater$default$2());
                Components$.MODULE$.build_components((Options)options2.elem, (List<Path>)((List)more_args.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Path apply(String str) {
                        return Path$.MODULE$.explode(str);
                    }
                }, List$.MODULE$.canBuildFrom())), progress, publish.elem, force.elem, update_components_sha1.elem);
            }

            private final String show_options$1(ObjectRef options$1) {
                return (String)package$.MODULE$.cat_lines().apply(Components$.MODULE$.isabelle$Components$$relevant_options().map((Function1)new Serializable(this, options$1){
                    public static final long serialVersionUID = 0L;
                    private final ObjectRef options$1;

                    public final String apply(String name2) {
                        return ((Options.Opt)((Options)this.options$1.elem).options().apply((Object)name2)).print();
                    }
                    {
                        this.options$1 = options$1;
                    }
                }, List$.MODULE$.canBuildFrom()));
            }
        });
    }
}

