/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bash$;
import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.Cygwin$;
import isabelle.Isabelle_System$;
import isabelle.Path;
import isabelle.Path$;
import isabelle.Platform$;
import isabelle.UTF8$;
import isabelle.Url$;
import isabelle.Word$;
import isabelle.XZ$;
import isabelle.package$;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystemException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.matching.Regex;

public final class File$ {
    public static final File$ MODULE$;
    private final Regex Cygdrive;
    private final Regex Named_Root;

    static {
        new File$();
    }

    public String standard_path(Path path2) {
        return path2.expand().implode();
    }

    public String standard_path(String platform_path2) {
        String string2;
        if (Platform$.MODULE$.is_windows()) {
            String string3;
            Regex Platform_Root = new Regex(new StringBuilder().append((Object)"(?i)").append((Object)Pattern.quote(Isabelle_System$.MODULE$.cygwin_root())).append((Object)"(?:\\\\+|\\z)(.*)").toString(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            Regex Drive = new Regex("([a-zA-Z]):\\\\*(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            String string4 = platform_path2.replace('/', '\\');
            Option option2 = Platform_Root.unapplySeq((CharSequence)string4);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                String rest = (String)((LinearSeqOptimized)option2.get()).apply(0);
                string3 = new StringBuilder().append((Object)"/").append((Object)rest.replace('\\', '/')).toString();
            } else {
                Option option3 = Drive.unapplySeq((CharSequence)string4);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    String letter = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    String string5 = rest;
                    String string6 = "";
                    string3 = new StringBuilder().append((Object)"/cygdrive/").append((Object)Word$.MODULE$.lowercase(letter)).append((Object)(!(string5 != null ? !string5.equals(string6) : string6 != null) ? "" : new StringBuilder().append((Object)"/").append((Object)rest.replace('\\', '/')).toString())).toString();
                } else {
                    string3 = string4.replace('\\', '/');
                }
            }
            string2 = string3;
        } else {
            string2 = platform_path2;
        }
        return string2;
    }

    public String standard_path(File file) {
        return this.standard_path(file.getPath());
    }

    public String standard_url(String name2) {
        String string2;
        try {
            URL url = new URL(name2);
            String string3 = url.getProtocol();
            String string4 = "file";
            string2 = !(string3 != null ? !string3.equals(string4) : string4 != null) && Url$.MODULE$.is_wellformed_file(name2) ? this.standard_path(Url$.MODULE$.parse_file(name2)) : name2;
        }
        catch (MalformedURLException malformedURLException) {
            string2 = this.standard_path(name2);
        }
        return string2;
    }

    private Regex Cygdrive() {
        return this.Cygdrive;
    }

    private Regex Named_Root() {
        return this.Named_Root;
    }

    public String platform_path(String standard_path) {
        String string2;
        if (Platform$.MODULE$.is_windows()) {
            String string3;
            StringBuilder result_path = new StringBuilder();
            String string4 = standard_path;
            Option option2 = this.Cygdrive().unapplySeq((CharSequence)string4);
            if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                String drive = (String)((LinearSeqOptimized)option2.get()).apply(0);
                String rest = (String)((LinearSeqOptimized)option2.get()).apply(1);
                result_path.$plus$plus$eq(new StringBuilder().append((Object)Word$.MODULE$.uppercase(drive)).append((Object)":").append((Object)File.separator).toString());
                string3 = rest;
            } else {
                Option option3 = this.Named_Root().unapplySeq((CharSequence)string4);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(2) == 0) {
                    String root = (String)((LinearSeqOptimized)option3.get()).apply(0);
                    String rest = (String)((LinearSeqOptimized)option3.get()).apply(1);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(File.separator);
                    result_path.$plus$plus$eq(root);
                    string3 = rest;
                } else if (string4.startsWith("/")) {
                    result_path.$plus$plus$eq(Isabelle_System$.MODULE$.cygwin_root());
                    string3 = string4;
                } else {
                    string3 = string4;
                }
            }
            String rest = string3;
            ((TraversableLike)package$.MODULE$.space_explode().apply((Object)BoxesRunTime.boxToCharacter((char)'/'), (Object)rest)).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String p) {
                    String string2 = p;
                    String string3 = "";
                    return string2 != null ? !string2.equals(string3) : string3 != null;
                }
            }).foreach((Function1)new Serializable(result_path){
                public static final long serialVersionUID = 0L;
                private final StringBuilder result_path$1;

                public final StringBuilder apply(String p) {
                    int len = this.result_path$1.length();
                    Object object = len > 0 && this.result_path$1.apply(len - 1) != File.separatorChar ? this.result_path$1.$plus$eq(File.separatorChar) : BoxedUnit.UNIT;
                    return this.result_path$1.$plus$plus$eq(p);
                }
                {
                    this.result_path$1 = result_path$1;
                }
            });
            string2 = result_path.toString();
        } else {
            string2 = standard_path;
        }
        return string2;
    }

    public String platform_path(Path path2) {
        return this.platform_path(this.standard_path(path2));
    }

    public File platform_file(Path path2) {
        return new File(this.platform_path(path2));
    }

    public File absolute(File file) {
        return file.toPath().toAbsolutePath().normalize().toFile();
    }

    public String absolute_name(File file) {
        return this.absolute(file).getPath();
    }

    public File canonical(File file) {
        return file.getCanonicalFile();
    }

    public String canonical_name(File file) {
        return this.canonical(file).getPath();
    }

    public Path path(File file) {
        return Path$.MODULE$.explode(this.standard_path(file));
    }

    public Path pwd() {
        return this.path(Path$.MODULE$.current().absolute_file());
    }

    public Option<Path> relative_path(Path base, Path other) {
        java.nio.file.Path base_path = base.file().toPath();
        java.nio.file.Path other_path = other.file().toPath();
        return other_path.startsWith(base_path) ? new Some((Object)this.path(base_path.relativize(other_path).toFile())) : None$.MODULE$;
    }

    public Option<Path> rebase_path(Path base, Path other) {
        return this.relative_path(base, other).map((Function1)new Serializable(base){
            public static final long serialVersionUID = 0L;
            private final Path base$1;

            public final Path apply(Path x$1) {
                return this.base$1.$plus(x$1);
            }
            {
                this.base$1 = base$1;
            }
        });
    }

    public String bash_path(Path path2) {
        return Bash$.MODULE$.string(this.standard_path(path2));
    }

    public String bash_path(File file) {
        return Bash$.MODULE$.string(this.standard_path(file));
    }

    public Path check_dir(Path path2) {
        return path2.is_dir() ? path2 : (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"No such directory: ").append((Object)path2).toString());
    }

    public Path check_file(Path path2) {
        return path2.is_file() ? path2 : (Path)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"No such file: ").append((Object)path2).toString());
    }

    public List<String> read_dir(Path dir) {
        Object object = dir.is_dir() ? BoxedUnit.UNIT : package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"No such directory: ").append((Object)dir.toString()).toString());
        File[] files = dir.file().listFiles();
        return files == null ? Nil$.MODULE$ : (List)((SeqLike)Predef$.MODULE$.refArrayOps((Object[])files).toList().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(File x$2) {
                return x$2.getName();
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$);
    }

    public List<File> find_files(File start2, Function1<File, Object> pred, boolean include_dirs, boolean follow_links) {
        Object object;
        ListBuffer result2 = new ListBuffer();
        if (start2.isFile()) {
            this.isabelle$File$$check$1(start2, pred, result2);
            object = BoxedUnit.UNIT;
        } else if (start2.isDirectory()) {
            EnumSet<FileVisitOption> options2 = follow_links ? EnumSet.of(FileVisitOption.FOLLOW_LINKS) : EnumSet.noneOf(FileVisitOption.class);
            object = Files.walkFileTree(start2.toPath(), options2, Integer.MAX_VALUE, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(pred, include_dirs, result2){
                private final Function1 pred$1;
                private final boolean include_dirs$1;
                private final ListBuffer result$1;

                public FileVisitResult preVisitDirectory(java.nio.file.Path path2, BasicFileAttributes attrs) {
                    if (this.include_dirs$1) {
                        File$.MODULE$.isabelle$File$$check$1(path2.toFile(), this.pred$1, this.result$1);
                    }
                    return FileVisitResult.CONTINUE;
                }

                public FileVisitResult visitFile(java.nio.file.Path path2, BasicFileAttributes attrs) {
                    File file = path2.toFile();
                    if (this.include_dirs$1 || !file.isDirectory()) {
                        File$.MODULE$.isabelle$File$$check$1(file, this.pred$1, this.result$1);
                    }
                    return FileVisitResult.CONTINUE;
                }
                {
                    this.pred$1 = pred$1;
                    this.include_dirs$1 = include_dirs$1;
                    this.result$1 = result$1;
                }
            });
        } else {
            object = BoxedUnit.UNIT;
        }
        return result2.toList();
    }

    public Function1<File, Object> find_files$default$2() {
        return new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$3) {
                return true;
            }
        };
    }

    public boolean find_files$default$3() {
        return false;
    }

    public boolean find_files$default$4() {
        return false;
    }

    public String read(File file) {
        return Bytes$.MODULE$.read(file).text();
    }

    public String read(Path path2) {
        return this.read(path2.file());
    }

    public String read_stream(BufferedReader reader) {
        StringBuilder output2 = new StringBuilder(100);
        int c = -1;
        while ((c = reader.read()) != -1) {
            output2.$plus$eq((char)c);
        }
        reader.close();
        return output2.toString();
    }

    public String read_stream(InputStream stream) {
        return this.read_stream(new BufferedReader(new InputStreamReader(stream, UTF8$.MODULE$.charset())));
    }

    public String read_gzip(File file) {
        return this.read_stream(new GZIPInputStream(new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_gzip(Path path2) {
        return this.read_gzip(path2.file());
    }

    public String read_xz(File file) {
        return this.read_stream((InputStream)new XZInputStream((InputStream)new BufferedInputStream(new FileInputStream(file))));
    }

    public String read_xz(Path path2) {
        return this.read_xz(path2.file());
    }

    public Option<String> read_line(BufferedReader reader) {
        String string2;
        try {
            string2 = reader.readLine();
        }
        catch (IOException iOException) {
            string2 = null;
        }
        String line = string2;
        return line == null ? None$.MODULE$ : new Some((Object)line);
    }

    public List<String> read_lines(BufferedReader reader, Function1<String, BoxedUnit> progress) {
        ListBuffer result2 = new ListBuffer();
        Option<String> line = None$.MODULE$;
        while ((line = this.read_line(reader)).isDefined()) {
            progress.apply(line.get());
            result2.$plus$eq(line.get());
        }
        reader.close();
        return result2.toList();
    }

    public void write_file(File file, CharSequence text2, Function1<OutputStream, OutputStream> make_stream) {
        OutputStream stream = (OutputStream)make_stream.apply((Object)new FileOutputStream(file));
        package$.MODULE$.using(new BufferedWriter(new OutputStreamWriter(stream, UTF8$.MODULE$.charset())), new Serializable(text2){
            public static final long serialVersionUID = 0L;
            private final CharSequence text$1;

            public final Writer apply(BufferedWriter x$4) {
                return x$4.append(this.text$1);
            }
            {
                this.text$1 = text$1;
            }
        });
    }

    public void write(File file, CharSequence text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final OutputStream apply(OutputStream s) {
                return s;
            }
        });
    }

    public void write(Path path2, CharSequence text2) {
        this.write(path2.file(), text2);
    }

    public void write_gzip(File file, CharSequence text2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final GZIPOutputStream apply(OutputStream s) {
                return new GZIPOutputStream(new BufferedOutputStream(s));
            }
        });
    }

    public void write_gzip(Path path2, CharSequence text2) {
        this.write_gzip(path2.file(), text2);
    }

    public void write_xz(File file, CharSequence text2, LZMA2Options options2) {
        this.write_file(file, text2, (Function1<OutputStream, OutputStream>)new Serializable(options2){
            public static final long serialVersionUID = 0L;
            private final LZMA2Options options$1;

            public final XZOutputStream apply(OutputStream s) {
                return new XZOutputStream((OutputStream)new BufferedOutputStream(s), (FilterOptions)this.options$1);
            }
            {
                this.options$1 = options$1;
            }
        });
    }

    public void write_xz(File file, CharSequence text2) {
        this.write_xz(file, text2, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_xz(Path path2, CharSequence text2, LZMA2Options options2) {
        this.write_xz(path2.file(), text2, options2);
    }

    public void write_xz(Path path2, CharSequence text2) {
        this.write_xz(path2, text2, XZ$.MODULE$.options(XZ$.MODULE$.options$default$1()));
    }

    public void write_backup(Path path2, CharSequence text2) {
        if (path2.is_file()) {
            this.move(path2, path2.backup());
        }
        this.write(path2, text2);
    }

    public void write_backup2(Path path2, CharSequence text2) {
        if (path2.is_file()) {
            this.move(path2, path2.backup2());
        }
        this.write(path2, text2);
    }

    public void append(File file, CharSequence text2) {
        Files.write(file.toPath(), UTF8$.MODULE$.bytes(((Object)text2).toString()), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
    }

    public void append(Path path2, CharSequence text2) {
        this.append(path2.file(), text2);
    }

    public boolean eq(File file1, File file2) {
        boolean bl;
        try {
            bl = Files.isSameFile(file1.toPath(), file2.toPath());
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public boolean eq(Path path1, Path path2) {
        return this.eq(path1.file(), path2.file());
    }

    public boolean eq_content(File file1, File file2) {
        boolean bl;
        if (this.eq(file1, file2)) {
            bl = true;
        } else if (file1.length() != file2.length()) {
            bl = false;
        } else {
            Bytes bytes = Bytes$.MODULE$.read(file1);
            Bytes bytes2 = Bytes$.MODULE$.read(file2);
            bl = !(bytes != null ? !((Object)bytes).equals(bytes2) : bytes2 != null);
        }
        return bl;
    }

    public boolean eq_content(Path path1, Path path2) {
        return this.eq_content(path1.file(), path2.file());
    }

    public void copy(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!this.eq(src, target)) {
            Files.copy(src.toPath(), target.toPath(), StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void copy(Path path1, Path path2) {
        this.copy(path1.file(), path2.file());
    }

    public void move(File src, File dst) {
        File target;
        File file = target = dst.isDirectory() ? new File(dst, src.getName()) : dst;
        if (!this.eq(src, target)) {
            Files.move(src.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public void move(Path path1, Path path2) {
        this.move(path1.file(), path2.file());
    }

    public void link(Path src, Path dst, boolean force) {
        Throwable throwable2;
        block3: {
            File src_file = src.file();
            File dst_file = dst.file();
            File target = dst_file.isDirectory() ? new File(dst_file, src_file.getName()) : dst_file;
            Object object = force ? BoxesRunTime.boxToBoolean((boolean)target.delete()) : BoxedUnit.UNIT;
            try {
                Files.createSymbolicLink(target.toPath(), src_file.toPath(), new FileAttribute[0]);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                if (throwable3 instanceof UnsupportedOperationException && Platform$.MODULE$.is_windows()) {
                    Cygwin$.MODULE$.link(this.standard_path(src), target);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                if (!(throwable3 instanceof FileSystemException) || !Platform$.MODULE$.is_windows()) break block3;
                Cygwin$.MODULE$.link(this.standard_path(src), target);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public boolean link$default$3() {
        return false;
    }

    public boolean is_executable(Path path2) {
        return Platform$.MODULE$.is_windows() ? Isabelle_System$.MODULE$.bash(new StringBuilder().append((Object)"test -x ").append((Object)this.bash_path(path2)).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check().ok() : path2.file().canExecute();
    }

    public void set_executable(Path path2, boolean flag) {
        if (Platform$.MODULE$.is_windows() && flag) {
            Isabelle_System$.MODULE$.bash(new StringBuilder().append((Object)"chmod a+x ").append((Object)this.bash_path(path2)).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
        } else if (Platform$.MODULE$.is_windows()) {
            Isabelle_System$.MODULE$.bash(new StringBuilder().append((Object)"chmod a-x ").append((Object)this.bash_path(path2)).toString(), Isabelle_System$.MODULE$.bash$default$2(), Isabelle_System$.MODULE$.bash$default$3(), Isabelle_System$.MODULE$.bash$default$4(), Isabelle_System$.MODULE$.bash$default$5(), Isabelle_System$.MODULE$.bash$default$6(), Isabelle_System$.MODULE$.bash$default$7(), Isabelle_System$.MODULE$.bash$default$8(), Isabelle_System$.MODULE$.bash$default$9()).check();
        } else {
            path2.file().setExecutable(flag, false);
        }
    }

    public final void isabelle$File$$check$1(File file, Function1 pred$1, ListBuffer result$1) {
        if (BoxesRunTime.unboxToBoolean((Object)pred$1.apply((Object)file))) {
            result$1.$plus$eq((Object)file);
        }
    }

    private File$() {
        MODULE$ = this;
        this.Cygdrive = new Regex("/cygdrive/([a-zA-Z])($|/.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        this.Named_Root = new Regex("//+([^/]*)(.*)", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
    }
}

