/*
 * Decompiled with CFR 0.152.
 */
package isabelle;

import isabelle.Bytes;
import isabelle.Bytes$;
import isabelle.File$;
import isabelle.UTF8$;
import isabelle.package$;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class Url$ {
    public static final Url$ MODULE$;

    static {
        new Url$();
    }

    public String escape_special(char c) {
        return new StringOps(Predef$.MODULE$.augmentString("!#$&'()*+,/:;=?@[]")).contains((Object)BoxesRunTime.boxToCharacter((char)c)) ? String.format(Locale.ROOT, "%%%02X", new Integer(c)) : ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
    }

    public String escape_special(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s)).iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(char x$1) {
                return Url$.MODULE$.escape_special(x$1);
            }
        }).mkString();
    }

    public String escape_name(String name2) {
        return new StringOps(Predef$.MODULE$.augmentString(name2)).iterator().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(char x0$1) {
                String string2;
                char c = x0$1;
                switch (c) {
                    default: {
                        string2 = ((Object)BoxesRunTime.boxToCharacter((char)c)).toString();
                        break;
                    }
                    case '\'': {
                        string2 = "%27";
                    }
                }
                return string2;
            }
        }).mkString();
    }

    public URL apply(String name2) {
        URL uRL;
        try {
            uRL = new URL(name2);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = (URL)package$.MODULE$.error().apply((Object)new StringBuilder().append((Object)"Malformed URL ").append(package$.MODULE$.quote().apply((Object)name2)).toString());
        }
        return uRL;
    }

    public boolean is_wellformed(String name2) {
        boolean bl;
        try {
            this.apply(name2);
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public boolean is_readable(String name2) {
        boolean bl;
        try {
            this.apply(name2).openStream().close();
            bl = true;
        }
        catch (Throwable throwable) {
            boolean bl2;
            Throwable throwable2 = throwable;
            Option<String> option2 = package$.MODULE$.ERROR().unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            bl = bl2 = false;
        }
        return bl;
    }

    public String decode(String s) {
        return URLDecoder.decode(s, UTF8$.MODULE$.charset_name());
    }

    public String encode(String s) {
        return URLEncoder.encode(s, UTF8$.MODULE$.charset_name());
    }

    private String read(URL url, boolean gzip) {
        return (String)package$.MODULE$.using(url.openStream(), new Serializable(gzip){
            public static final long serialVersionUID = 0L;
            private final boolean gzip$1;

            public final String apply(InputStream stream) {
                return File$.MODULE$.read_stream(this.gzip$1 ? new GZIPInputStream(stream) : stream);
            }
            {
                this.gzip$1 = gzip$1;
            }
        });
    }

    public String read(URL url) {
        return this.read(url, false);
    }

    public String read_gzip(URL url) {
        return this.read(url, true);
    }

    public String read(String name2) {
        return this.read(this.apply(name2), false);
    }

    public String read_gzip(String name2) {
        return this.read(this.apply(name2), true);
    }

    public Bytes read_bytes(URL url) {
        URLConnection connection = url.openConnection();
        int length2 = connection.getContentLength();
        return (Bytes)package$.MODULE$.using(connection.getInputStream(), new Serializable(length2){
            public static final long serialVersionUID = 0L;
            private final int length$1;

            public final Bytes apply(InputStream x$2) {
                InputStream x$3 = x$2;
                int x$4 = this.length$1;
                int x$5 = Bytes$.MODULE$.read_stream$default$2();
                return Bytes$.MODULE$.read_stream(x$3, x$5, x$4);
            }
            {
                this.length$1 = length$1;
            }
        });
    }

    public String print_file(File file) {
        return File$.MODULE$.absolute(file).toPath().toUri().toString();
    }

    public String print_file_name(String name2) {
        return this.print_file(new File(name2));
    }

    public File parse_file(String uri) {
        return Paths.get(new URI(uri)).toFile();
    }

    public boolean is_wellformed_file(String uri) {
        Throwable throwable2;
        block2: {
            boolean bl;
            try {
                this.parse_file(uri);
                bl = true;
            }
            catch (Throwable throwable2) {
                boolean bl2;
                Throwable throwable3 = throwable2;
                boolean bl3 = throwable3 instanceof URISyntaxException ? true : (throwable3 instanceof IllegalArgumentException ? true : throwable3 instanceof FileSystemNotFoundException);
                if (!bl3) break block2;
                bl = bl2 = false;
            }
            return bl;
        }
        throw throwable2;
    }

    public File absolute_file(String uri) {
        return File$.MODULE$.absolute(this.parse_file(uri));
    }

    public String absolute_file_name(String uri) {
        return this.absolute_file(uri).getPath();
    }

    public File canonical_file(String uri) {
        return File$.MODULE$.canonical(this.parse_file(uri));
    }

    public String canonical_file_name(String uri) {
        return this.canonical_file(uri).getPath();
    }

    private Url$() {
        MODULE$ = this;
    }
}

