/*
 * Decompiled with CFR 0.152.
 */
package info.javaspec.engine;

import info.javaspec.api.SpecClass;
import info.javaspec.engine.ExecutableTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

final class ContextDescriptor
extends AbstractTestDescriptor
implements ExecutableTestDescriptor {
    public static ContextDescriptor forEngine(UniqueId engineId) {
        return new ContextDescriptor(engineId, "JavaSpec");
    }

    public static ContextDescriptor forDeclaringClass(UniqueId parentId, Class<? extends SpecClass> declaringClass) {
        return new ContextDescriptor(parentId.append("class", declaringClass.getName()), declaringClass.getName());
    }

    public static ContextDescriptor describe(UniqueId parentId, String what) {
        return new ContextDescriptor(parentId.append("describe-block", what), what);
    }

    public static ContextDescriptor given(UniqueId parentId, String what) {
        return new ContextDescriptor(parentId.append("given-block", what), String.format("given %s", what));
    }

    private ContextDescriptor(UniqueId uniqueId, String displayName) {
        super(uniqueId, displayName);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public void execute(EngineExecutionListener listener) {
        listener.executionStarted((TestDescriptor)this);
        for (TestDescriptor child : this.getChildren()) {
            ExecutableTestDescriptor executableChild = (ExecutableTestDescriptor)ExecutableTestDescriptor.class.cast(child);
            executableChild.execute(listener);
        }
        listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
    }
}

