/*
 * Decompiled with CFR 0.152.
 */
package info.javaspec.engine;

import info.javaspec.engine.ContextDescriptor;
import info.javaspec.engine.EngineDiscoveryRequestListener;
import info.javaspec.engine.EngineDiscoveryRequestListenerProvider;
import info.javaspec.engine.ExecutableTestDescriptor;
import info.javaspec.engine.SpecClassDeclaration;
import java.util.Optional;
import java.util.ServiceLoader;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;

public class JavaSpecEngine
implements TestEngine {
    private final EngineDiscoveryRequestListenerProvider loader;

    public JavaSpecEngine() {
        this.loader = () -> ServiceLoader.load(EngineDiscoveryRequestListener.class).findFirst();
    }

    JavaSpecEngine(EngineDiscoveryRequestListenerProvider loader) {
        this.loader = loader;
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest, UniqueId engineId) {
        this.loader.findFirst().ifPresent(listener -> listener.onDiscover(discoveryRequest));
        ContextDescriptor engineDescriptor = ContextDescriptor.forEngine(engineId);
        discoveryRequest.getSelectorsByType(ClassSelector.class).stream().map(ClassSelector::getJavaClass).map(selectedClass -> new SpecClassDeclaration((Class<?>)selectedClass)).map(declaration -> declaration.run(engineId)).filter(Optional::isPresent).map(Optional::orElseThrow).forEach(arg_0 -> ((ExecutableTestDescriptor)engineDescriptor).addChild(arg_0));
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        ExecutableTestDescriptor engineDescriptor = (ExecutableTestDescriptor)ExecutableTestDescriptor.class.cast(request.getRootTestDescriptor());
        engineDescriptor.execute(request.getEngineExecutionListener());
    }

    public String getId() {
        return "javaspec-engine";
    }
}

