/*
 * Decompiled with CFR 0.152.
 */
package info.javaspec.engine;

import info.javaspec.api.BehaviorDeclaration;
import info.javaspec.api.JavaSpec;
import info.javaspec.api.SpecClass;
import info.javaspec.api.Verification;
import info.javaspec.engine.ContextDescriptor;
import info.javaspec.engine.SkippedSpecDescriptor;
import info.javaspec.engine.SpecDescriptor;
import java.lang.reflect.Constructor;
import java.util.Optional;
import java.util.Stack;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

final class SpecClassDeclaration
implements JavaSpec {
    private final Class<?> selectedClass;
    private final Stack<ContextDescriptor> containersInScope;

    public SpecClassDeclaration(Class<?> selectedClass) {
        this.selectedClass = selectedClass;
        this.containersInScope = new Stack();
    }

    public Optional<TestDescriptor> run(UniqueId engineId) {
        return Optional.of(this.selectedClass).filter(SpecClass.class::isAssignableFrom).map(this::instantiate).map(SpecClass.class::cast).map(declaringInstance -> this.discover(engineId, (SpecClass)declaringInstance));
    }

    private ContextDescriptor discover(UniqueId engineId, SpecClass declaringInstance) {
        this.enterScope(ContextDescriptor.forDeclaringClass(engineId, declaringInstance.getClass()));
        declaringInstance.declareSpecs((JavaSpec)this);
        return this.exitScope();
    }

    private Object instantiate(Class<?> specClass) {
        try {
            Constructor<?> constructor = specClass.getDeclaredConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate spec class", e);
        }
    }

    public void describe(Class<?> aClass, BehaviorDeclaration declaration) {
        this.pushChildContainer(declaration, parent -> ContextDescriptor.describe(parent.getUniqueId(), aClass.getSimpleName()));
    }

    public void describe(String what, BehaviorDeclaration declaration) {
        this.pushChildContainer(declaration, parent -> ContextDescriptor.describe(parent.getUniqueId(), what));
    }

    public void given(String what, BehaviorDeclaration declaration) {
        this.pushChildContainer(declaration, parent -> ContextDescriptor.given(parent.getUniqueId(), what));
    }

    private void pushChildContainer(BehaviorDeclaration block, ContainerDescriptorFactory factory) {
        ContextDescriptor current = this.currentContainer();
        ContextDescriptor child = factory.makeChildContainer(current);
        current.addChild(child);
        this.enterScope(child);
        block.declare();
        this.exitScope();
    }

    public void it(String behavior, Verification verification) {
        this.addToCurrentContainer(container -> SpecDescriptor.of(container.getUniqueId(), behavior, verification));
    }

    public void pending(String futureBehavior) {
        this.addToCurrentContainer(container -> SkippedSpecDescriptor.pending(container.getUniqueId(), futureBehavior));
    }

    public void skip(String intendedBehavior, Verification brokenVerification) {
        this.addToCurrentContainer(container -> SkippedSpecDescriptor.disabled(container.getUniqueId(), intendedBehavior));
    }

    private void addToCurrentContainer(TestDescriptorFactory factory) {
        ContextDescriptor container = this.currentContainer();
        TestDescriptor specDescriptor = factory.makeTestDescriptor(container);
        container.addChild(specDescriptor);
    }

    private ContextDescriptor currentContainer() {
        return this.containersInScope.peek();
    }

    private void enterScope(ContextDescriptor container) {
        this.containersInScope.push(container);
    }

    private ContextDescriptor exitScope() {
        return this.containersInScope.pop();
    }

    @FunctionalInterface
    private static interface TestDescriptorFactory {
        public TestDescriptor makeTestDescriptor(ContextDescriptor var1);
    }

    @FunctionalInterface
    private static interface ContainerDescriptorFactory {
        public ContextDescriptor makeChildContainer(ContextDescriptor var1);
    }
}

