/*
 * Decompiled with CFR 0.152.
 */
package info.javaspec.engine;

import info.javaspec.api.Verification;
import info.javaspec.engine.ExecutableTestDescriptor;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;

final class SpecDescriptor
extends AbstractTestDescriptor
implements ExecutableTestDescriptor {
    private final Verification verification;

    public static SpecDescriptor of(UniqueId parentId, String behavior, Verification verification) {
        return new SpecDescriptor(parentId.append("test", behavior), behavior, verification);
    }

    private SpecDescriptor(UniqueId uniqueId, String displayName, Verification verification) {
        super(uniqueId, displayName);
        this.verification = verification;
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.TEST;
    }

    @Override
    public void execute(EngineExecutionListener listener) {
        listener.executionStarted((TestDescriptor)this);
        try {
            this.verification.execute();
        }
        catch (AssertionError | Exception e) {
            listener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)e));
            return;
        }
        listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
    }
}

