/*
 * Decompiled with CFR 0.152.
 */
package ar.com.kfgodel.nary.api;

import ar.com.kfgodel.nary.api.Unary;
import ar.com.kfgodel.nary.api.arity.MultiElement;
import ar.com.kfgodel.nary.impl.EmptyNary;
import ar.com.kfgodel.nary.impl.OneElementNary;
import ar.com.kfgodel.nary.impl.StreamBasedNary;
import ar.com.kfgodel.nary.impl.others.EnumerationSpliterator;
import ar.com.kfgodel.nary.impl.others.OneElementSupplierSpliterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Nary<T>
extends MultiElement<T> {
    public boolean equals(Object var1);

    public int hashCode();

    public String toString();

    public static <T> Unary<T> empty() {
        return EmptyNary.instance();
    }

    public static <T> Nary<T> from(Stream<? extends T> stream) {
        if (stream instanceof Nary) {
            return (Nary)stream;
        }
        return StreamBasedNary.create(stream);
    }

    public static <T> Unary<T> ofNonNullable(T element) {
        return OneElementNary.create(element);
    }

    public static <T> Nary<T> ofNonNullable(T element, T ... additionals) {
        Unary<T> elementNary = Nary.ofNonNullable(element);
        if (additionals == null || additionals.length == 0) {
            return elementNary;
        }
        Nary<T> additionalsNary = Nary.from(additionals);
        return elementNary.concat(additionalsNary);
    }

    public static <T> Unary<T> of(T nullableElement) {
        if (nullableElement == null) {
            return Nary.empty();
        }
        return Nary.ofNonNullable(nullableElement);
    }

    public static <T> Unary<T> from(Optional<? extends T> nativeOptional) {
        return nativeOptional.map(Nary::ofNonNullable).orElseGet(Nary::empty);
    }

    public static <T> Nary<T> from(Spliterator<T> spliterator) {
        Stream<T> stream = StreamSupport.stream(spliterator, false);
        return Nary.from(stream);
    }

    public static <T> Nary<T> from(Iterator<T> iterator) {
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, 0);
        return Nary.from(spliterator);
    }

    public static <T> Nary<T> from(Iterable<T> iterable) {
        Spliterator<T> spliterator = iterable.spliterator();
        return Nary.from(spliterator);
    }

    public static <T> Nary<T> from(Supplier<T> supplier) {
        return Nary.from(OneElementSupplierSpliterator.create(supplier));
    }

    public static <T> Nary<T> from(Collection<T> collection) {
        Stream<T> stream = collection.stream();
        return Nary.from(stream);
    }

    public static <T> Nary<T> from(T[] array) {
        Stream<T> asStream = Arrays.stream(array);
        return Nary.from(asStream);
    }

    public static <T> Nary<T> from(Enumeration<T> enumeration) {
        EnumerationSpliterator<T> spliterator = EnumerationSpliterator.create(enumeration);
        return Nary.from(spliterator);
    }

    public static <K, V> Nary<Map.Entry<K, V>> from(Map<K, V> map) {
        return Nary.from(map.entrySet().stream());
    }
}

