/*
 * Decompiled with CFR 0.152.
 */
package ar.com.kfgodel.nary.impl;

import ar.com.kfgodel.nary.api.Nary;
import ar.com.kfgodel.nary.api.Unary;
import ar.com.kfgodel.nary.api.exceptions.MoreThanOneElementException;
import com.google.common.collect.Iterators;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Collector;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public abstract class NarySupport<T>
implements Nary<T> {
    @Override
    public Nary<T> concat(Stream<? extends T> other) {
        return this.returningNaryDo(Stream.concat(this, other));
    }

    @Override
    public Nary<T> concat(Optional<? extends T> other) {
        return this.concat(Nary.from(other));
    }

    @Override
    public Nary<T> add(T ... others) {
        return this.concat(Nary.from(others));
    }

    @Override
    public <U> Nary<U> mapFilteringNullResult(Function<? super T, ? extends U> mapper) {
        return this.map(mapper).filter(Objects::nonNull);
    }

    @Override
    public <U> Nary<U> flatMapOptional(Function<? super T, Optional<U>> mapper) throws MoreThanOneElementException {
        return this.map(mapper).flatMap(Nary::from);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator) {
        R container = supplier.get();
        for (T element : this) {
            accumulator.accept(container, element);
        }
        return container;
    }

    protected abstract Stream<T> asStream();

    @Override
    public Nary<T> filter(Predicate<? super T> predicate) {
        return this.returningNaryDo(this.asStream().filter(predicate));
    }

    @Override
    public <R> Nary<R> map(Function<? super T, ? extends R> mapper) {
        return this.returningNaryDo(this.asStream().map(mapper));
    }

    @Override
    public IntStream mapToInt(ToIntFunction<? super T> mapper) {
        return this.asStream().mapToInt(mapper);
    }

    @Override
    public LongStream mapToLong(ToLongFunction<? super T> mapper) {
        return this.asStream().mapToLong(mapper);
    }

    @Override
    public DoubleStream mapToDouble(ToDoubleFunction<? super T> mapper) {
        return this.asStream().mapToDouble(mapper);
    }

    @Override
    public <R> Nary<R> flatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        return this.returningNaryDo(this.asStream().flatMap(mapper));
    }

    @Override
    public IntStream flatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        return this.asStream().flatMapToInt(mapper);
    }

    @Override
    public LongStream flatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        return this.asStream().flatMapToLong(mapper);
    }

    @Override
    public DoubleStream flatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        return this.asStream().flatMapToDouble(mapper);
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.asStream().forEach(action);
    }

    @Override
    public void forEachOrdered(Consumer<? super T> action) {
        this.asStream().forEachOrdered(action);
    }

    @Override
    public Object[] toArray() {
        return this.asStream().toArray();
    }

    @Override
    public <A> A[] toArray(IntFunction<A[]> generator) {
        return this.asStream().toArray(generator);
    }

    @Override
    public T reduce(T identity, BinaryOperator<T> accumulator) {
        return this.asStream().reduce(identity, accumulator);
    }

    @Override
    public Optional<T> reduce(BinaryOperator<T> accumulator) {
        return this.asStream().reduce(accumulator);
    }

    @Override
    public <U> U reduce(U identity, BiFunction<U, ? super T, U> accumulator, BinaryOperator<U> combiner) {
        return this.asStream().reduce(identity, accumulator, combiner);
    }

    @Override
    public <R> R collect(Supplier<R> supplier, BiConsumer<R, ? super T> accumulator, BiConsumer<R, R> combiner) {
        return this.asStream().collect(supplier, accumulator, combiner);
    }

    @Override
    public <R, A> R collect(Collector<? super T, A, R> collector) {
        return this.asStream().collect(collector);
    }

    @Override
    public Optional<T> min(Comparator<? super T> comparator) {
        return this.asStream().min(comparator);
    }

    @Override
    public Optional<T> max(Comparator<? super T> comparator) {
        return this.asStream().max(comparator);
    }

    @Override
    public long count() {
        return this.asStream().count();
    }

    @Override
    public boolean anyMatch(Predicate<? super T> predicate) {
        return this.asStream().anyMatch(predicate);
    }

    @Override
    public boolean allMatch(Predicate<? super T> predicate) {
        return this.asStream().allMatch(predicate);
    }

    @Override
    public boolean noneMatch(Predicate<? super T> predicate) {
        return this.asStream().noneMatch(predicate);
    }

    @Override
    public Optional<T> findFirst() {
        return this.asStream().findFirst();
    }

    @Override
    public Optional<T> findAny() {
        return this.asStream().findAny();
    }

    @Override
    public Iterator<T> iterator() {
        return this.asStream().iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.asStream().spliterator();
    }

    @Override
    public boolean isParallel() {
        return this.asStream().isParallel();
    }

    @Override
    public Stream<T> sequential() {
        return (Stream)this.asStream().sequential();
    }

    @Override
    public Stream<T> parallel() {
        return (Stream)this.asStream().parallel();
    }

    @Override
    public Stream<T> unordered() {
        return (Stream)this.asStream().unordered();
    }

    @Override
    public Stream<T> onClose(Runnable closeHandler) {
        return (Stream)this.asStream().onClose(closeHandler);
    }

    @Override
    public void close() {
        this.asStream().close();
    }

    @Override
    public Unary<T> findLast() {
        return this.reduceNary(this::keepLast);
    }

    private T keepLast(T previous, T current) {
        return current;
    }

    @Override
    public Nary<T> distinct() {
        return this.returningNaryDo(this.asStream().distinct());
    }

    @Override
    public Nary<T> sorted() {
        return this.returningNaryDo(this.asStream().sorted());
    }

    @Override
    public Nary<T> sorted(Comparator<? super T> comparator) {
        return this.returningNaryDo(this.asStream().sorted(comparator));
    }

    @Override
    public Nary<T> peek(Consumer<? super T> action) {
        return this.returningNaryDo(this.asStream().peek(action));
    }

    @Override
    public Nary<T> limit(long maxSize) {
        return this.returningNaryDo(this.asStream().limit(maxSize));
    }

    @Override
    public Nary<T> skip(long n) {
        return this.returningNaryDo(this.asStream().skip(n));
    }

    @Override
    public Unary<T> reduceNary(BinaryOperator<T> accumulator) {
        return this.returningNaryDo(this.reduce(accumulator));
    }

    @Override
    public Unary<T> minNary(Comparator<? super T> comparator) {
        return this.returningNaryDo(this.min(comparator));
    }

    @Override
    public Unary<T> maxNary(Comparator<? super T> comparator) {
        return this.returningNaryDo(this.max(comparator));
    }

    @Override
    public Unary<T> findFirstNary() {
        return this.returningNaryDo(this.findFirst());
    }

    @Override
    public Unary<T> findAnyNary() {
        return this.returningNaryDo(this.findAny());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Nary)) {
            return false;
        }
        Nary that = (Nary)obj;
        return Iterators.elementsEqual(this.iterator(), that.iterator());
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (T e : this) {
            hashCode = 31 * hashCode + Objects.hashCode(e);
        }
        return hashCode;
    }

    protected <R> Nary<R> returningNaryDo(Stream<R> nativeStream) {
        return Nary.from(nativeStream);
    }

    protected Unary<T> returningNaryDo(Optional<T> nativeOptional) {
        return Nary.from(nativeOptional);
    }
}

